% Modifikovan fzov korelace
% Holografick snmek + Fluorescenn snmek DAPI

% Pozn. V kodu jsou moznosti pro zobrazeni jednotlivych obrazku

clc;
clear;
close all;

% naten obrzk zadnm cesty 

% N musi byt vetsi nez rozmery obrazku a
% udava rozmery vystredenych obrazku

zadani_cesty_f='Zadejte cestu k fluorescennmu snmku Alexa Fluor: ';
cesta_fluo=input(zadani_cesty_f,'s');

zadani_cesty_h='Zadejte cestu k holografickmu snmku: ';
cesta_holo=input(zadani_cesty_h,'s');

fluo_obr=im2double((imread(cesta_fluo)));               
holo_obr=im2double((imread(cesta_holo)));                

rozmery_fluo=size(fluo_obr);
rozmery_holo=size(holo_obr);
N=2048;                                  

disp('Probh skldn...');

% 0. preprocesing
% uprava obrazku pro pouzitelnost v MATLABu

holo_real=linearni_skalovani(holo_obr);
fluo_real=linearni_skalovani(fluo_obr);

% figure;
% imshow(holo_real);
% figure;
% imshow(fluo_real);

% 1. centering (kvuli pripadnym rozdilnym rozmerum obrazku)
               
c1_fluo=centering(fluo_real,N);
c1_holo=centering(holo_real,N);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(c1_holo));
% imshow((c1_holo)/max2);
% impixelinfo;

% 2. vynasobeni originalnich obrazku window funkcemi

kruh_window1=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.34,0,30,0,N);    %(220,0,20,0,N)
kruh_window2=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.34,0,30,0,N);    %(220,0,20,0,N)

w1_fluo=c1_fluo.*kruh_window1;
w1_holo=c1_holo.*kruh_window2;

% figure;
% imshow(w1_fluo);
% figure;
% imshow(w1_holo);

% 3. vypoet amplitud Fourierovch spekter

abs_fftA=abs(fftshift(fft2(w1_fluo)));     %.*kruh_window3;
abs_fftB=abs(fftshift(fft2(w1_holo)));     %.*kruh_window4;
 
% figure;
% abs_ffA_t=log(1+abs_fftA);
% max1=max(max(abs_ffA_t));
% imshow((abs_ffA_t/max1));
% figure;
% abs_ffB_t=log(1+abs_fftB);
% max2=max(max(abs_ffB_t));
% imshow((abs_ffB_t/max2));

% 4. pevod do polrnch souadnic

lp_fluo=(log_polar(log(1+(abs_fftA))));                   
lp_holo=(log_polar(log(1+(abs_fftB))));              

% figure;
% maxlp_fluo=max(max(lp_fluo));
% imshow(lp_fluo/maxlp_fluo);
% impixelinfo;
% maxlp_holo=max(max(lp_holo));
% figure;
% imshow(lp_holo/maxlp_holo);
% impixelinfo;

% % 5. vpoet polo-normalizovanho cross-power spektra

fftA=(fftshift(fft2(lp_fluo)));              
fftB=(fftshift(fft2(lp_holo)));           

abs_fftA=abs(fftA);
abs_fftB=abs(fftB);

max_amp_fluo2=max(max(abs_fftA))*0.01;
max_amp_holo2=max(max(abs_fftB))*0.01;

p=max_amp_fluo2/320;
q=max_amp_holo2/320;

% figure;
% maxabs_fftA=max(max(abs_fftA));
% imshow(abs_fftA/maxabs_fftA);
% impixelinfo;
% maxabs_fftB=max(max(abs_fftB));
% figure;
% imshow(abs_fftB/maxabs_fftB);
% impixelinfo;

% polo-normalizovane cross-power spektrum a vahova funkce
Z1=(fftA.*(conj(fftB)))./(((abs_fftA)+p).*((abs_fftB)+q));
vahova_fce_Z1=kruhova_Gauss_window_funkce(60,0,30,0,N);  
Zo1=(((Z1)).*vahova_fce_Z1);

% figure;
% imshow((vahova_fce_Z1));
% impixelinfo;

% modifikovana fazova korelace

I1=abs(fftshift(ifft2(Zo1)));
I1max=max(max(I1));
faz_kor1=(I1/I1max);

% figure;                        
% imshow((I1/I1max));
% impixelinfo;

% nalezeni maxima, vypocet rotace a zvetseni

[c d]=find(I1==I1max);
zvetseni_a_rotace=vypocet_teziste_v2(c,d,I1,10);

a=exp((log(N)-log(2))/N);
zvetseni=exp((zvetseni_a_rotace(1,2))*log(a));
rotace=180.0*((zvetseni_a_rotace(1,1)))/(N);

% 6. rotace a zvten obrzk

holo_rot=imrotate(c1_holo,rotace,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
holo_zve=imresize(holo_rot,(1/(zvetseni)),'bilinear');

% figure;
% maxholo_zve=max(max(holo_zve));
% imshow(holo_zve/maxholo_zve);
% impixelinfo;

% 7. centering

rozmery_holo_nove=size(holo_zve);
rozmery=[rozmery_holo_nove rozmery_fluo];
O=max(rozmery);

c2_fluo=centering(c1_fluo,O);
c2_holo=centering(holo_zve,O);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(holo_zve));
% imshow((holo_zve)/max2);
% impixelinfo;

% 8. Window fce upravench obrzk

kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40+15,0,30,0,O);    
kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40,0,30,0,O);

w2_fluo=c2_fluo.*kruh_window5;
w2_holo=c2_holo.*kruh_window6;

% figure;
% max1=max(max(w2_fluo));
% imshow((w2_fluo/max1));
% figure;
% max2=max(max(w2_holo));
% imshow((w2_holo/max2));

% 9. vypoet amplitudovch spekter a vpoet polo-normalizovanho cross-power spektra

fftC=(fftshift(fft2(w2_fluo)));                
fftD=(fftshift(fft2(w2_holo)));              

abs_fftC=abs(fftC);
abs_fftD=abs(fftD);

max_amp_fluo2=max(max(abs_fftC))*0.01;
max_amp_holo2=max(max(abs_fftD))*0.01;

p=max_amp_fluo2/170;
q=max_amp_holo2/170;

% figure;
% maxabs_fftC=max(max(abs_fftC));
% imshow(abs_fftC/maxabs_fftC);
% impixelinfo;
% maxabs_fftD=max(max(abs_fftD));
% figure;
% imshow(abs_fftD/maxabs_fftD);
% impixelinfo;

% figure;
% abs_ffC_t=log(1+abs_fftC);
% max1=max(max(abs_ffC_t));
% imshow((abs_ffC_t/max1));
% figure;
% abs_ffD_t=log(1+abs_fftD);
% max2=max(max(abs_ffD_t));
% imshow((abs_ffD_t/max2));

% polo-normalizovane cross-power spektrum a vahova fce
Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
vahova_fce_Z2=kruhova_Gauss_window_funkce(60,0,30,0,O);  
Zo2=((Z2).*vahova_fce_Z2);

% figure;
% imshow((vahova_fce_Z2));
% impixelinfo;

% modifikovana fazova korelace
I2=abs(fftshift(ifft2(Zo2)));
Imax2=max(max(I2));
faz_kor2=(I2/Imax2);

% figure;                                                  
% imshow(faz_kor2);
% impixelinfo;

% posuv (v pixelech)
[e f]=find(I2==Imax2);
posuvy=vypocet_teziste_v2(e,f,I2,10);

posuv_x=round(posuvy(1,1)-1);
posuv_y=round(posuvy(1,2)-1);

% 10. Posunut

posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

% figure;
% max1=max(max(posunuty_vzor));
% imshow((posunuty_vzor/max1));
% impixelinfo;

% 11. centering (kvuli pripadnym rozdilnym rozmerum obrazku)

rozmery_fluo2=size(c2_fluo);
rozmery_holo2=size(posunuty_vzor);
rozmery=[rozmery_fluo2 rozmery_holo2];
M=max(rozmery);

c3_fluo=centering(c2_fluo,M);
c3_holo=centering(posunuty_vzor,M);

% figure;
% max1=max(max(f_fluo));
% imshow((f_fluo/max1));
% impixelinfo;
% 
% figure;
% max1=max(max(f_holo));
% imshow((f_holo/max1));
% impixelinfo;

% 12. oznut

okrajovy_parametr=0.95;

rozmery_cele=[M M];
rozmery_puvodni=size(holo_real);

start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

oriznute_fluo=adapthisteq(imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));
oriznute_holo=adapthisteq(imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));

% figure;
% imshow((oriznute_fluo));
% impixelinfo;
% 
% figure;
% imshow((oriznute_holo));
% impixelinfo;

% 13. slozeni
P=size(oriznute_fluo);

kombinace_snimku=zeros(P(1,1),P(1,2),3);
kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
kombinace_snimku(:,:,2)=0;                                    % green
kombinace_snimku(:,:,3)=oriznute_fluo/(max(max(oriznute_fluo)));                                               % blue

% 14. pedbn vstup

K=figure;
set(K, 'Name', 'Kontroln kombinovan snimek');
imshow((kombinace_snimku));
impixelinfo;

Pomer_velikosti_a_rotace=sprintf('Pomr velikost %d a rotace %d ve stupnch.',zvetseni,rotace);
disp(Pomer_velikosti_a_rotace);
Posunuti=sprintf('Vektor posunut (%d,%d) v pixelech.',posuv_x,posuv_y);
disp(Posunuti);

% Zpetna vazba - eliminace falesneho maxima

dotaz1='Byla registrace obraz spn? Napite slo jako odpov (1-Ano, 0-Ne):';

A=figure;
set(A, 'Name', 'Fazova korelace (vlevo mtko a rotace, vpravo vzjemn posun)');
subplot(1,2,1);
imshow(faz_kor1);
hold on;
plot(d,c,'r.','MarkerSize',5);
subplot(1,2,2);
imshow(faz_kor2);
hold on;
plot(f,e,'r.','MarkerSize',5);
impixelinfo;

odpoved1=input(dotaz1);

while odpoved1==0

disp('Je problm s urenm pomru velikost/rotac nebo se vzjemnm posunem?');
dotaz2='Napite slo jako odpov (1-Zvten/Rotace, 2-Posun):';
odpoved2=input(dotaz2);

if odpoved2==1
    
% patn pomr velikost nebo rotace    

dotaz3='Znte sprvn hodnoty pomru velikost i rotace? (1-Ano, 0-Ne):';
odpoved3=input(dotaz3);   

% zadn sprvnch hodnot

        if odpoved3==1
        zvetseni_dotaz='Pomr velikost (nap. 1.054):';
        zvetseni_odpoved=input(zvetseni_dotaz); 
        rotace_dotaz='Rotace ve stupnch (nap. 0.532):';
        rotace_odpoved=input(rotace_dotaz); 

        holo_rot=imrotate(c1_holo,rotace_odpoved,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
        holo_zve=imresize(holo_rot,(1/(zvetseni_odpoved)),'bilinear');

        rozmery_holo_nove=size(holo_zve);
        rozmery=[rozmery_holo_nove rozmery_fluo];
        O=max(rozmery);

        c2_fluo=centering(c1_fluo,O);
        c2_holo=centering(holo_zve,O);

        kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40+15,0,30,0,O);    
        kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40,0,30,0,O);

        w2_fluo=c2_fluo.*kruh_window5;
        w2_holo=c2_holo.*kruh_window6;

        fftC=(fftshift(fft2(w2_fluo)));                %.*kruh_window7;
        fftD=(fftshift(fft2(w2_holo)));                %.*kruh_window8;

        abs_fftC=abs(fftC);
        abs_fftD=abs(fftD);

        max_amp_fluo2=max(max(abs_fftC))*0.01;
        max_amp_holo2=max(max(abs_fftD))*0.01;

        p=max_amp_fluo2/170;
        q=max_amp_holo2/170;

        Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
        vahova_fce_Z2=kruhova_Gauss_window_funkce(60,0,30,0,O);  
        Zo2=((Z2).*vahova_fce_Z2);

        I2=abs(fftshift(ifft2(Zo2)));
        Imax2=max(max(I2));
        faz_kor2=(I2/Imax2);

        [e f]=find(I2==Imax2);
        posuvy=vypocet_teziste_v2(e,f,I2,10);

        posuv_x=round(posuvy(1,1)-1);
        posuv_y=round(posuvy(1,2)-1);

        posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

        rozmery_fluo2=size(c2_fluo);
        rozmery_holo2=size(posunuty_vzor);
        rozmery=[rozmery_fluo2 rozmery_holo2];
        M=max(rozmery);

        c3_fluo=centering(c2_fluo,M);
        c3_holo=centering(posunuty_vzor,M);

        okrajovy_parametr=0.95;

        rozmery_cele=[M M];
        rozmery_puvodni=size(holo_real);

        start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
        start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

        oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
        oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

        oriznute_fluo=adapthisteq(imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));
        oriznute_holo=adapthisteq(imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));

        rozmery5=size(oriznute_fluo);
        rozmery6=size(oriznute_holo);
        P=max([rozmery5 rozmery6]);

        kombinace_snimku=zeros(P,P,3);
        kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
        kombinace_snimku(:,:,2)=0;                                     % green
        kombinace_snimku(:,:,3)=oriznute_fluo/(max(max(oriznute_fluo)));                                               % blue

        K=figure;
        set(K, 'Name', 'Kontroln kombinovan snimek');
        imshow((kombinace_snimku));
        impixelinfo;

        Pomer_velikosti_a_rotace=sprintf('Pomr velikost %d a rotace %d ve stupnch.',zvetseni,rotace);
        disp(Pomer_velikosti_a_rotace);
        Posunuti=sprintf('Vektor posunut (%d,%d) v pixelech.',posuv_x,posuv_y);
        disp(Posunuti);

        dotaz1='Byla registrace obraz spn? Napite slo jako odpov (1-Ano, 0-Ne):';
        odpoved1=input(dotaz1);

        end

        if odpoved3==0
        % neznme sprvn hodnoty pom. velimosti a rotace, eliminace fal. maxima    
        faz_kor1=faz_kor1.*eliminace_maxima(faz_kor1, 11, d, c);
        max_faz_kor1=max(max(faz_kor1));

        [c d]=find(faz_kor1==max_faz_kor1);
        zvetseni_a_rotace=vypocet_teziste_v2(c,d,(I1/I1max),10);

        a=exp((log(N)-log(2))/N);
        zvetseni=exp((zvetseni_a_rotace(1,2))*log(a));
        rotace=180.0*((zvetseni_a_rotace(1,1)))/(N);

        W=figure;
        set(W, 'Name', 'Fazova korelace - pomr zvten a vzjemn rotace');
        subplot(1,2,1);
        imshow(I1/I1max);
        hold on;
        plot(d,c,'r.','MarkerSize',5);
        subplot(1,2,2);
        imshow(faz_kor1/max_faz_kor1);
        hold on;
        plot(d,c,'r.','MarkerSize',5);
        impixelinfo;

        holo_rot=imrotate(c1_holo,rotace,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
        holo_zve=imresize(holo_rot,(1/(zvetseni)),'bilinear');

        rozmery_holo_nove=size(holo_zve);
        rozmery=[rozmery_holo_nove rozmery_fluo];
        O=max(rozmery);

        c2_fluo=centering(c1_fluo,O);
        c2_holo=centering(holo_zve,O);

        kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40+15,0,30,0,O);    
        kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.40,0,30,0,O);

        w2_fluo=c2_fluo.*kruh_window5;
        w2_holo=c2_holo.*kruh_window6;

        fftC=(fftshift(fft2(w2_fluo)));                
        fftD=(fftshift(fft2(w2_holo)));              

        abs_fftC=abs(fftC);
        abs_fftD=abs(fftD);
        max_amp_fluo2=max(max(abs_fftC))*0.01;
        max_amp_holo2=max(max(abs_fftD))*0.01;

        p=max_amp_fluo2/170;
        q=max_amp_holo2/170;

        Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
        vahova_fce_Z2=kruhova_Gauss_window_funkce(60,0,30,0,O);  
        Zo2=((Z2).*vahova_fce_Z2);

        I2=abs(fftshift(ifft2(Zo2)));
        Imax2=max(max(I2));
        faz_kor2=(I2/Imax2);

        [e f]=find(I2==Imax2);
        posuvy=vypocet_teziste_v2(e,f,I2,10);

        posuv_x=round(posuvy(1,1)-1);
        posuv_y=round(posuvy(1,2)-1);

        posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

        rozmery_fluo2=size(c2_fluo);
        rozmery_holo2=size(posunuty_vzor);
        rozmery=[rozmery_fluo2 rozmery_holo2];
        M=max(rozmery);

        c3_fluo=centering(c2_fluo,M);
        c3_holo=centering(posunuty_vzor,M);

        okrajovy_parametr=0.95;

        rozmery_cele=[M M];
        rozmery_puvodni=size(holo_real);

        start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
        start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

        oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
        oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

        oriznute_fluo=adapthisteq(imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));
        oriznute_holo=adapthisteq(imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));

        rozmery5=size(oriznute_fluo);
        rozmery6=size(oriznute_holo);
        P=max([rozmery5 rozmery6]);

        kombinace_snimku=zeros(P,P,3);
        kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
        kombinace_snimku(:,:,2)=0;                                     % green
        kombinace_snimku(:,:,3)=oriznute_fluo/(max(max(oriznute_fluo)));                                               % blue

        K=figure;
        set(K, 'Name', 'Kontroln kombinovan snimek');
        imshow((kombinace_snimku));
        impixelinfo;

        Pomer_velikosti_a_rotace=sprintf('Pomr velikost %d a rotace %d ve stupnch.',zvetseni,rotace);
        disp(Pomer_velikosti_a_rotace);
        Posunuti=sprintf('Vektor posunut (%d,%d) v pixelech.',posuv_x,posuv_y);
        disp(Posunuti);

        dotaz1='Byla registrace obraz spn? Napite slo jako odpov (1-Ano, 0-Ne):';

        odpoved1=input(dotaz1);

        end
end

if odpoved2==2 
         
% eliminace falenho maxima, chyba se vzjemnm posunem  
faz_kor2=faz_kor2.*eliminace_maxima(faz_kor2, 11, f, e);
max_faz_kor2=max(max(faz_kor2));    

[e f]=find(faz_kor2==max_faz_kor2);
posuvy=vypocet_teziste_v2(e,f,(I2/Imax2),10);

posuv_x=round(posuvy(1,1)-1);
posuv_y=round(posuvy(1,2)-1);

Q=figure;
set(Q, 'Name', 'Fazova korelace - vzjemn posunut');
subplot(1,2,1);
imshow(I2/Imax2);
hold on;
plot(f,e,'r.','MarkerSize',5);
subplot(1,2,2);
imshow(faz_kor2/max_faz_kor2);
hold on;
plot(f,e,'r.','MarkerSize',5);
impixelinfo;

posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

rozmery_fluo2=size(c2_fluo);
rozmery_holo2=size(posunuty_vzor);
rozmery=[rozmery_fluo2 rozmery_holo2];
M=max(rozmery);

c3_fluo=centering(c2_fluo,M);
c3_holo=centering(posunuty_vzor,M);

okrajovy_parametr=0.95;

rozmery_cele=[M M];
rozmery_puvodni=size(holo_real);

start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

oriznute_fluo=adapthisteq(imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));
oriznute_holo=adapthisteq(imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));

rozmery5=size(oriznute_fluo);
rozmery6=size(oriznute_holo);
P=max([rozmery5 rozmery6]);

kombinace_snimku=zeros(P,P,3);
kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
kombinace_snimku(:,:,2)=0;                                  % green
kombinace_snimku(:,:,3)=oriznute_fluo/(max(max(oriznute_fluo)));                                               % blue

K=figure;
set(K, 'Name', 'Kontroln kombinovan snimek');
imshow((kombinace_snimku));
impixelinfo;

Pomer_velikosti_a_rotace=sprintf('Pomr velikost %d a rotace %d ve stupnch.',zvetseni,rotace);
disp(Pomer_velikosti_a_rotace);
Posunuti=sprintf('Vektor posunut (%d,%d) v pixelech.',posuv_x,posuv_y);
disp(Posunuti);

dotaz1='Byla registrace obraz spn? Napite slo jako odpov (1-Ano, 0-Ne):';

odpoved1=input(dotaz1);

end

end    

% Vstup

zadani_cesty_f1='Zadejte jmeno, umisteni a format sloenho fluorescennmu snmku DAPI: ';
cesta_fluo1=input(zadani_cesty_f1,'s');

zadani_cesty_h1='Zadejte jmeno, umisteni a format sloenho holografickho snmku: ';
cesta_holo1=input(zadani_cesty_h1,'s');

zadani_cesty_c1='Zadejte jmeno, umisteni a format kombinovanho snmku: ';
cesta_combi1=input(zadani_cesty_c1,'s');

imwrite(oriznute_fluo,cesta_fluo1);
imwrite(oriznute_holo,cesta_holo1);
imwrite(kombinace_snimku,cesta_combi1);
disp('Konec!');



