% Fazova korelace hromadne AlexaFluor
% statisticka metoda pouze pro 20 dvojic a vice!
% obrazky vkladat ve formatu 1_fluo, 1_holo atd

clc;
clear;
close all;

% Volba metody

disp('Sloit dvojice snmk statistickou metodou nebo bez n?');
dotaz1='Napite slo jako odpov (1-Statisticky, 2-Jednotliv):';
odpoved1=input(dotaz1);

% Pouit statistiky - hledn zvten a rotace

if odpoved1==1

dotaz2='Zadejte poet dvojic snmk (nap. 25): ';
pocet=input(dotaz2);

dotaz3='Zadejte horn rozsah pomru velikost (nap. 1.15): ';
rozsah_zvetseni=input(dotaz3)-1;

dotaz4='Zadejte horn rozsah vzjemnho natoen snmk (nap. 3): ';
rozsah_rotace=input(dotaz4);

for i=1:pocet

formatSpec='%d/%d Prbh';
prubeh=sprintf(formatSpec,i,pocet);
disp(prubeh);  
    
formatSpec='%d_fluo.tiff';
Fluo1=sprintf(formatSpec,i);

formatSpec='%da_holo.tiff';
Holo1=sprintf(formatSpec,i);  

% naten obrzk 
fluo_obr=im2double(((imread(Fluo1))));                
holo_obr=im2double(((imread(Holo1))));               

rozmery_fluo=size(fluo_obr);
rozmery_holo=size(holo_obr);
N=2048;                                  

% 0. preprocesing

holo_real=linearni_skalovani(holo_obr);
fluo_real=linearni_skalovani(fluo_obr);
holo_eq=adapthisteq(holo_real);
fluo_eq=adapthisteq(fluo_real);

% figure;
% imshow(holo_real);
% figure;
% imshow(fluo_real);

% 1. centering (kvuli pripadnym rozdilnym rozmerum obrazku)
               
c1_fluo=centering(fluo_eq,N);
c1_holo=centering(holo_eq,N);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(c1_holo));
% imshow((c1_holo)/max2);
% impixelinfo;

% 2. vynasobeni originalnich obrazku window funkcemi

kruh_window1=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.43,0,30,0,N);    %(220,0,20,0,N)
kruh_window2=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.43,0,30,0,N);    %(220,0,20,0,N)

w1_fluo=c1_fluo.*kruh_window1;
w1_holo=c1_holo.*kruh_window2;

% figure;
% imshow(w1_fluo);
% figure;
% imshow(w1_holo);

% 3. vypoet amplitud Fourierovch spekter

abs_fftA=abs(fftshift(fft2(w1_fluo)));     
abs_fftB=abs(fftshift(fft2(w1_holo)));     
 
% figure;
% abs_ffA_t=log(1+abs_fftA);
% max1=max(max(abs_ffA_t));
% imshow((abs_ffA_t/max1));
% figure;
% abs_ffB_t=log(1+abs_fftB);
% max2=max(max(abs_ffB_t));
% imshow((abs_ffB_t/max2));

% 4. pevod do polrnch souadnic

lp_fluo=(log_polar(log(1+(abs_fftA))));                   
lp_holo=(log_polar(log(1+(abs_fftB))));                  

% figure;
% maxlp_fluo=max(max(lp_fluo));
% imshow(lp_fluo/maxlp_fluo);
% impixelinfo;
% maxlp_holo=max(max(lp_holo));
% figure;
% imshow(lp_holo/maxlp_holo);
% impixelinfo;

% % 5. vpoet polo-normalizovanho cross-power spektra

fftA=(fftshift(fft2(lp_fluo)));             
fftB=(fftshift(fft2(lp_holo)));             

abs_fftA=abs(fftA);
abs_fftB=abs(fftB);

max_amp_fluo2=max(max(abs_fftA))*0.01;
max_amp_holo2=max(max(abs_fftB))*0.01;

p=max_amp_fluo2/320;
q=max_amp_holo2/320;

% figure;
% maxabs_fftA=max(max(abs_fftA));
% imshow(abs_fftA/maxabs_fftA);
% impixelinfo;
% maxabs_fftB=max(max(abs_fftB));
% figure;
% imshow(abs_fftB/maxabs_fftB);
% impixelinfo;

% normalizovane cross-power spektrum a vahova funkce
Z1=(fftA.*(conj(fftB)))./(((abs_fftA)+p).*((abs_fftB)+q));
vahova_fce_Z1=kruhova_Gauss_window_funkce(62,10,36,7,N);  
Zo1=(((Z1)).*vahova_fce_Z1);

% figure;
% imshow((vahova_fce_Z1));
% impixelinfo;

% modifikovana fazova korelace
I1=abs(fftshift(ifft2(Zo1)));
I1max=max(max(I1));
faz_kor1=(I1/I1max);

% figure;                        
% imshow((I1/I1max));
% impixelinfo;

% nalezen maxima, vypocet rotace a zvetseni

[c d]=find(I1==I1max);
zvetseni_a_rotace=vypocet_teziste_v2(c,d,I1,11);

a=exp((log(N)-log(2))/N);
zvetseni(i)=exp((zvetseni_a_rotace(1,2))*log(a));
rotace(i)=180.0*((zvetseni_a_rotace(1,1)))/(N);

end

% nalezen sprvn hodnoty vzjemn rotace a pomru velikost

spravnost=0;

while spravnost==0

[nove_zvetseni, nova_rotace]=statistika(zvetseni, rotace, rozsah_zvetseni, rozsah_rotace);
pocet_maxim_zvetseni=max(size(nove_zvetseni));
pocet_maxim_rotace=max(size(nova_rotace));
disp('Byly nalezeny tyto pomry velikost a pootoen');

% vypis vsech zjistenych moznych hodnot pomeru velikosti a rotaci
    for j=1:pocet_maxim_zvetseni
    
    Pomer_velikosti=sprintf('%d. Pomr velikost %d.',j,nove_zvetseni(j));
    disp(Pomer_velikosti);
    
    end
    
    for j=1:pocet_maxim_rotace
    
    vz_rotace=sprintf('%d. Rotace %d ve stupnch.',j,nova_rotace(j));
    disp(vz_rotace);
    
    end

% volba spravnch hodnot
dotaz5='Zadejte hodnotu pomru velikost (nap. 1.015):';
spravne_zvetseni=input(dotaz5);
dotaz6='Zadejte hodnotu vzjemnho pootoen ve stupnch (nap. 0.5):';
spravna_rotace=input(dotaz6);

disp('Probh oven...');

% Oven sprvn volby skldacch parametr

% naten obrzk

fluo_obr=im2double(imread('2_fluo.tiff')); 
holo_obr=im2double(imread('2_holo.tiff'));

rozmery_fluo=size(fluo_obr);
rozmery_holo=size(holo_obr);
N=2048;                                  

% 0. preprocesing

holo_real=linearni_skalovani(holo_obr);
fluo_real=linearni_skalovani(fluo_obr);
holo_eq=adapthisteq(holo_real);
fluo_eq=adapthisteq(fluo_real);

% figure;
% imshow(holo_real);
% figure;
% imshow(fluo_real);

% 1. centering (kvuli pripadnym rozdilnym rozmerum obrazku)
               
c1_fluo=centering(fluo_eq,N);
c1_holo=centering(holo_eq,N);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(c1_holo));
% imshow((c1_holo)/max2);
% impixelinfo;

holo_rot=imrotate(c1_holo,spravna_rotace,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
holo_zve=imresize(holo_rot,(1/(spravne_zvetseni)),'bilinear');

% figure;
% maxholo_zve=max(max(holo_zve));
% imshow(holo_zve/maxholo_zve);
% impixelinfo;

% 7. centering

rozmery_holo_nove=size(holo_zve);
rozmery=[rozmery_holo_nove rozmery_fluo];
O=max(rozmery);

c2_fluo=centering(c1_fluo,O);
c2_holo=centering(holo_zve,O);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(holo_zve));
% imshow((holo_zve)/max2);
% impixelinfo;

% 8. Window fce upravench obrzk

kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/spravne_zvetseni)*0.43,0,30,0,O);    
kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/spravne_zvetseni)*0.43,0,30,0,O);

w2_fluo=c2_fluo.*kruh_window5;
w2_holo=c2_holo.*kruh_window6;

% figure;
% max1=max(max(w2_fluo));
% imshow((w2_fluo/max1));
% figure;
% max2=max(max(w2_holo));
% imshow((w2_holo/max2));

% 9. vypoet amplitudovch spekter a vpoet polo-normalizovanho cross-power spektra

fftC=(fftshift(fft2(w2_fluo)));               
fftD=(fftshift(fft2(w2_holo)));              

abs_fftC=abs(fftC);
abs_fftD=abs(fftD);
p=0.001;
q=0.001;

% figure;
% maxabs_fftC=max(max(abs_fftC));
% imshow(abs_fftC/maxabs_fftC);
% impixelinfo;
% maxabs_fftD=max(max(abs_fftD));
% figure;
% imshow(abs_fftD/maxabs_fftD);
% impixelinfo;

% figure;
% abs_ffC_t=log(1+abs_fftC);
% max1=max(max(abs_ffC_t));
% imshow((abs_ffC_t/max1));
% figure;
% abs_ffD_t=log(1+abs_fftD);
% max2=max(max(abs_ffD_t));
% imshow((abs_ffD_t/max2));

Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
vahova_fce_Z2=kruhova_Gauss_window_funkce(62,0,30,0,O);  
Zo2=((Z2).*vahova_fce_Z2);

% figure;
% imshow((vahova_fce_Z2));
% impixelinfo;

I2=abs(fftshift(ifft2(Zo2)));
Imax2=max(max(I2));
faz_kor2=(I2/Imax2);

% figure;                                                  
% imshow(faz_kor2);
% impixelinfo;

% posuv (v pixelech)
[e f]=find(I2==Imax2);
posuvy=vypocet_teziste_v2(e,f,I2,11);

posuv_x=round(posuvy(1,1)-1);
posuv_y=round(posuvy(1,2)-1);

% 10. Posunut

posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

% figure;
% max1=max(max(posunuty_vzor));
% imshow((posunuty_vzor/max1));
% impixelinfo;

% 11. centering (kvuli pripadnym rozdilnym rozmerum obrazku)

rozmery_fluo2=size(c2_fluo);
rozmery_holo2=size(posunuty_vzor);
rozmery=[rozmery_fluo2 rozmery_holo2];
M=max(rozmery);

c3_fluo=centering(c2_fluo,M);
c3_holo=centering(posunuty_vzor,M);

% figure;
% max1=max(max(f_fluo));
% imshow((f_fluo/max1));
% impixelinfo;
% 
% figure;
% max1=max(max(f_holo));
% imshow((f_holo/max1));
% impixelinfo;

% 12. oznut

okrajovy_parametr=0.95;

rozmery_cele=[M M];
rozmery_puvodni=size(holo_real);

start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

oriznute_fluo=imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]);
oriznute_holo=imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]);

% figure;
% imshow((oriznute_fluo));
% impixelinfo;
% 
% figure;
% imshow((oriznute_holo));
% impixelinfo;

% 13. slozeni
rozmery5=size(oriznute_fluo);
rozmery6=size(oriznute_holo);
P=max([rozmery5 rozmery6]);

kombinace_snimku=zeros(P,P,3);
kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
kombinace_snimku(:,:,2)=oriznute_fluo/(max(max(oriznute_fluo)));         % green                               
kombinace_snimku(:,:,3)=0;                                               % blue

figure;
imshow(kombinace_snimku);

dotaz7='Bylo sloen spn? Zadejte slo jako odpov (1-Ano, 0-Ne): ';
spravnost=input(dotaz7);


end

% skldn dle sprvnch a ovench parametr

disp('Probh skldn...');

for i=1:pocet

formatSpec='%d_fluo.tiff';
Fluo1=sprintf(formatSpec,i);

formatSpec='%d_holo.tiff';
Holo1=sprintf(formatSpec,i);  

% naten obrzk 
fluo_obr=im2double(((imread(Fluo1))));                
holo_obr=im2double(((imread(Holo1))));                 

rozmery_fluo=size(fluo_obr);
rozmery_holo=size(holo_obr);
N=2048;                                  

% 0. preprocesing

holo_real=linearni_skalovani(holo_obr);
fluo_real=linearni_skalovani(fluo_obr);
holo_eq=adapthisteq(holo_real);
fluo_eq=adapthisteq(fluo_real);

% figure;
% imshow(holo_real);
% figure;
% imshow(fluo_real);

% 1. centering (kvuli pripadnym rozdilnym rozmerum obrazku)
               
c1_fluo=centering(fluo_eq,N);
c1_holo=centering(holo_eq,N);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(c1_holo));
% imshow((c1_holo)/max2);
% impixelinfo;

holo_rot=imrotate(c1_holo,spravna_rotace,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
holo_zve=imresize(holo_rot,(1/(spravne_zvetseni)),'bilinear');

% figure;
% maxholo_zve=max(max(holo_zve));
% imshow(holo_zve/maxholo_zve);
% impixelinfo;

% 7. centering

rozmery_holo_nove=size(holo_zve);
rozmery=[rozmery_holo_nove rozmery_fluo];
O=max(rozmery);

c2_fluo=centering(c1_fluo,O);
c2_holo=centering(holo_zve,O);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(holo_zve));
% imshow((holo_zve)/max2);
% impixelinfo;

% 8. Window fce upravench obrzk

kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/spravne_zvetseni)*0.43,0,30,0,O);    
kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/spravne_zvetseni)*0.43,0,30,0,O);

w2_fluo=c2_fluo.*kruh_window5;
w2_holo=c2_holo.*kruh_window6;

% figure;
% max1=max(max(w2_fluo));
% imshow((w2_fluo/max1));
% figure;
% max2=max(max(w2_holo));
% imshow((w2_holo/max2));

% 9. vypoet amplitudovch spekter a vpoet polo-normalizovanho cross-power spektra
% kruh_window7=kruhova_Gauss_window_funkce(200,45,28,10,O);   %(220,35,30,10,O);
% kruh_window8=kruhova_Gauss_window_funkce(200,45,28,10,O);   %(220,35,30,10,O);

fftC=(fftshift(fft2(w2_fluo)));                %.*kruh_window7;
fftD=(fftshift(fft2(w2_holo)));                %.*kruh_window8;

abs_fftC=abs(fftC);
abs_fftD=abs(fftD);
p=0.001;
q=0.001;

% figure;
% maxabs_fftC=max(max(abs_fftC));
% imshow(abs_fftC/maxabs_fftC);
% impixelinfo;
% maxabs_fftD=max(max(abs_fftD));
% figure;
% imshow(abs_fftD/maxabs_fftD);
% impixelinfo;

% figure;
% abs_ffC_t=log(1+abs_fftC);
% max1=max(max(abs_ffC_t));
% imshow((abs_ffC_t/max1));
% figure;
% abs_ffD_t=log(1+abs_fftD);
% max2=max(max(abs_ffD_t));
% imshow((abs_ffD_t/max2));

Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
vahova_fce_Z2=kruhova_Gauss_window_funkce(62,0,30,0,O);  
Zo2=((Z2).*vahova_fce_Z2);

% figure;
% imshow((vahova_fce_Z2));
% impixelinfo;

I2=abs(fftshift(ifft2(Zo2)));
Imax2=max(max(I2));
faz_kor2=(I2/Imax2);

% figure;                                                  
% imshow(faz_kor2);
% impixelinfo;

% posuv (v pixelech)
[e f]=find(I2==Imax2);
posuvy=vypocet_teziste_v2(e,f,I2,11);

posuv_x=round(posuvy(1,1)-1);
posuv_y=round(posuvy(1,2)-1);

% 10. Posunut

posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

% figure;
% max1=max(max(posunuty_vzor));
% imshow((posunuty_vzor/max1));
% impixelinfo;

% 11. centering (kvuli pripadnym rozdilnym rozmerum obrazku)

rozmery_fluo2=size(c2_fluo);
rozmery_holo2=size(posunuty_vzor);
rozmery=[rozmery_fluo2 rozmery_holo2];
M=max(rozmery);

c3_fluo=centering(c2_fluo,M);
c3_holo=centering(posunuty_vzor,M);

% figure;
% max1=max(max(f_fluo));
% imshow((f_fluo/max1));
% impixelinfo;
% 
% figure;
% max1=max(max(f_holo));
% imshow((f_holo/max1));
% impixelinfo;

% 12. oznut

okrajovy_parametr=0.95;

rozmery_cele=[M M];
rozmery_puvodni=size(holo_real);

start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

oriznute_fluo=imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]);
oriznute_holo=imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]);

% figure;
% imshow((oriznute_fluo));
% impixelinfo;
% 
% figure;
% imshow((oriznute_holo));
% impixelinfo;

% 13. slozeni
rozmery5=size(oriznute_fluo);
rozmery6=size(oriznute_holo);
P=max([rozmery5 rozmery6]);

kombinace_snimku=zeros(P,P,3);
kombinace_snimku(:,:,1)=oriznute_holo/(max(max(oriznute_holo)));         % red
kombinace_snimku(:,:,2)=oriznute_fluo/(max(max(oriznute_fluo)));         % green                               
kombinace_snimku(:,:,3)=0;                                               % blue

formatSpec='%dz_fluo.tiff';
w_fluo=sprintf(formatSpec,i);

formatSpec='%dz_holo.tiff';
w_holo=sprintf(formatSpec,i);  

formatSpec='%dz_combi.tiff';
w_combi=sprintf(formatSpec,i); 

imwrite(oriznute_fluo,w_fluo);                
imwrite(oriznute_holo,w_holo);                
imwrite(kombinace_snimku,w_combi);  

end
end

% individuln sloen

if odpoved1==2

dotaz2='Zadejte poet dvojic snmk (nap. 25): ';
pocet=input(dotaz2);

for i=1:pocet

formatSpec='%d/%d Prbh';
baf=sprintf(formatSpec,i,pocet);
disp(baf);  
    
formatSpec='%d_fluo.tiff';
Fluo1=sprintf(formatSpec,i);

formatSpec='%d_holo.tiff';
Holo1=sprintf(formatSpec,i);  

% naten obrzk 
fluo_obr=im2double(((imread(Fluo1))));                %1_texas.tiff
holo_obr=im2double(((imread(Holo1))));                 %1_holo.tiff

rozmery_fluo=size(fluo_obr);
rozmery_holo=size(holo_obr);
N=2048;                                  

% 0. preprocesing

holo_real=linearni_skalovani(holo_obr);
fluo_real=linearni_skalovani(fluo_obr);
holo_eq=adapthisteq(holo_real);
fluo_eq=adapthisteq(fluo_real);

% figure;
% imshow(holo_real);
% figure;
% imshow(fluo_real);

% 1. centering (kvuli pripadnym rozdilnym rozmerum obrazku)
               
c1_fluo=centering(fluo_eq,N);
c1_holo=centering(holo_eq,N);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(c1_holo));
% imshow((c1_holo)/max2);
% impixelinfo;

% 2. vynasobeni originalnich obrazku window funkcemi

kruh_window1=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.43,0,30,0,N);    
kruh_window2=kruhova_Gauss_window_funkce((rozmery_holo(1,1))*0.43,0,30,0,N);   

w1_fluo=c1_fluo.*kruh_window1;
w1_holo=c1_holo.*kruh_window2;

% figure;
% imshow(w1_fluo);
% figure;
% imshow(w1_holo);

% 3. vypoet amplitud Fourierovch spekter

abs_fftA=abs(fftshift(fft2(w1_fluo)));     
abs_fftB=abs(fftshift(fft2(w1_holo)));     
 
% figure;
% abs_ffA_t=log(1+abs_fftA);
% max1=max(max(abs_ffA_t));
% imshow((abs_ffA_t/max1));
% figure;
% abs_ffB_t=log(1+abs_fftB);
% max2=max(max(abs_ffB_t));
% imshow((abs_ffB_t/max2));

% 4. pevod do polrnch souadnic

lp_fluo=(log_polar(log(1+(abs_fftA))));                   
lp_holo=(log_polar(log(1+(abs_fftB))));                  

% figure;
% maxlp_fluo=max(max(lp_fluo));
% imshow(lp_fluo/maxlp_fluo);
% impixelinfo;
% maxlp_holo=max(max(lp_holo));
% figure;
% imshow(lp_holo/maxlp_holo);
% impixelinfo;

% % 5. vpoet polo-normalizovanho cross-power spektra

fftA=(fftshift(fft2(lp_fluo)));              
fftB=(fftshift(fft2(lp_holo)));              

abs_fftA=abs(fftA);
abs_fftB=abs(fftB);

max_amp_fluo2=max(max(abs_fftA))*0.01;
max_amp_holo2=max(max(abs_fftB))*0.01;

p=max_amp_fluo2/320;
q=max_amp_holo2/320;

% figure;
% maxabs_fftA=max(max(abs_fftA));
% imshow(abs_fftA/maxabs_fftA);
% impixelinfo;
% maxabs_fftB=max(max(abs_fftB));
% figure;
% imshow(abs_fftB/maxabs_fftB);
% impixelinfo;

Z1=(fftA.*(conj(fftB)))./(((abs_fftA)+p).*((abs_fftB)+q));
vahova_fce_Z1=kruhova_Gauss_window_funkce(62,10,36,7,N);  
Zo1=(((Z1)).*vahova_fce_Z1);

% figure;
% imshow((vahova_fce_Z1));
% impixelinfo;

I1=abs(fftshift(ifft2(Zo1)));
I1max=max(max(I1));
faz_kor1=(I1/I1max);

% figure;                        
% imshow((I1/I1max));
% impixelinfo;

% vypocet rotace a zvetseni

[c d]=find(I1==I1max);
zvetseni_a_rotace=vypocet_teziste_v2(c,d,I1,10);

a=exp((log(N)-log(2))/N);
zvetseni=exp((zvetseni_a_rotace(1,2))*log(a));
rotace=180.0*((zvetseni_a_rotace(1,1)))/(N);

holo_rot=imrotate(c1_holo,rotace,'bilinear','crop');   % 'nearest' 'bilinear' 'bicubic'
holo_zve=imresize(holo_rot,(1/(zvetseni)),'bilinear');

% figure;
% maxholo_zve=max(max(holo_zve));
% imshow(holo_zve/maxholo_zve);
% impixelinfo;

% 7. centering

rozmery_holo_nove=size(holo_zve);
rozmery=[rozmery_holo_nove rozmery_fluo];
O=max(rozmery);

c2_fluo=centering(c1_fluo,O);
c2_holo=centering(holo_zve,O);

% figure;
% max1=max(max(c1_fluo));
% imshow((c1_fluo)/max1);
% impixelinfo;
% figure;
% max2=max(max(holo_zve));
% imshow((holo_zve)/max2);
% impixelinfo;

% 8. Window fce upravench obrzk

kruh_window5=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.43,0,30,0,O);    
kruh_window6=kruhova_Gauss_window_funkce((rozmery_holo(1,1)/zvetseni)*0.43,0,30,0,O);

w2_fluo=c2_fluo.*kruh_window5;
w2_holo=c2_holo.*kruh_window6;

% figure;
% max1=max(max(w2_fluo));
% imshow((w2_fluo/max1));
% figure;
% max2=max(max(w2_holo));
% imshow((w2_holo/max2));

% 9. vypoet amplitudovch spekter a vpoet polo-normalizovanho cross-power spektra

fftC=(fftshift(fft2(w2_fluo)));                
fftD=(fftshift(fft2(w2_holo)));               

abs_fftC=abs(fftC);
abs_fftD=abs(fftD);

p=0.001;
q=0.001;

% figure;
% maxabs_fftC=max(max(abs_fftC));
% imshow(abs_fftC/maxabs_fftC);
% impixelinfo;
% maxabs_fftD=max(max(abs_fftD));
% figure;
% imshow(abs_fftD/maxabs_fftD);
% impixelinfo;

% figure;
% abs_ffC_t=log(1+abs_fftC);
% max1=max(max(abs_ffC_t));
% imshow((abs_ffC_t/max1));
% figure;
% abs_ffD_t=log(1+abs_fftD);
% max2=max(max(abs_ffD_t));
% imshow((abs_ffD_t/max2));

Z2=(fftC.*(conj(fftD)))./(((abs_fftC)+p).*((abs_fftD)+q));
vahova_fce_Z2=kruhova_Gauss_window_funkce(62,10,36,7,O);  
Zo2=((Z2).*vahova_fce_Z2);

% figure;
% imshow((vahova_fce_Z2));
% impixelinfo;

I2=abs(fftshift(ifft2(Zo2)));
Imax2=max(max(I2));
faz_kor2=(I2/Imax2);

% figure;                                                  
% imshow(faz_kor2);
% impixelinfo;

% posuv (v pixelech)
[e f]=find(I2==Imax2);
posuvy=vypocet_teziste_v2(e,f,I2,10);

posuv_x=round(posuvy(1,1)-1);
posuv_y=round(posuvy(1,2)-1);

% 10. Posunut

posunuty_vzor=Posunuti_obrazku_v2(c2_holo,+posuv_x,+posuv_y);

% figure;
% max1=max(max(posunuty_vzor));
% imshow((posunuty_vzor/max1));
% impixelinfo;

% 11. centering (kvuli pripadnym rozdilnym rozmerum obrazku)

rozmery_fluo2=size(c2_fluo);
rozmery_holo2=size(posunuty_vzor);
rozmery=[rozmery_fluo2 rozmery_holo2];
M=max(rozmery);

c3_fluo=centering(c2_fluo,M);
c3_holo=centering(posunuty_vzor,M);

% figure;
% max1=max(max(f_fluo));
% imshow((f_fluo/max1));
% impixelinfo;
% 
% figure;
% max1=max(max(f_holo));
% imshow((f_holo/max1));
% impixelinfo;

% 12. oznut

okrajovy_parametr=0.95;

rozmery_cele=[M M];
rozmery_puvodni=size(holo_real);

start_bod_x=round(((rozmery_cele(1,1))/2)-((rozmery_puvodni(1,1)*okrajovy_parametr)/2));
start_bod_y=round(((rozmery_cele(1,2))/2)-((rozmery_puvodni(1,2)*okrajovy_parametr)/2));

oblast_x=round((rozmery_puvodni(1,1)*okrajovy_parametr));
oblast_y=round((rozmery_puvodni(1,2)*okrajovy_parametr));

oriznute_fluo=(imcrop(c3_fluo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));
oriznute_holo=(imcrop(c3_holo,[(start_bod_x+posuv_y) (start_bod_y+posuv_x) oblast_x oblast_y]));

% figure;
% imshow((oriznute_fluo));
% impixelinfo;
% 
% figure;
% imshow((oriznute_holo));
% impixelinfo;

% 13. slozeni
rozmery5=size(oriznute_fluo);
rozmery6=size(oriznute_holo);
P=max([rozmery5 rozmery6]);

kombinace_snimku=zeros(P,P,3);
kombinace_snimku(:,:,1)=(oriznute_holo/(max(max(oriznute_holo))));         % red
kombinace_snimku(:,:,2)=0;                                                            % green                               
kombinace_snimku(:,:,3)=(oriznute_fluo/(max(max(oriznute_fluo))));         % blue

formatSpec='%dz_fluo.tiff';
w_fluo=sprintf(formatSpec,i);

formatSpec='%dz_holo.tiff';
w_holo=sprintf(formatSpec,i);  

formatSpec='%dz_combi.tiff';
w_combi=sprintf(formatSpec,i); 

imwrite(oriznute_fluo,w_fluo);                
imwrite(oriznute_holo,w_holo);                
imwrite(kombinace_snimku,w_combi);


end
end

disp('Konec!');
beep on;
beep;