function povrch = wli_weight_center(Zax, InData, Delta, minD, minH, nPeaks)
%WLI_WEIGHT_CENTER najde stredy interferencnich prouzku metody vahovani
%    maxim.
%   
%    povrch = wli_weight_center(Zax, Data, Delta, minD, minH, nPeaks)
%       Zax      - osa z (napr. z interferometru) [micro m]
%       Data     - namerene intentizy
%       Delta    - vzdalenost od absolutniho maxima, kterou prohledavat
%                  [micro m]
%       minD     - minimalni vzdalenost detakovanych maxim [micro m]
%       minH     - minimalni intenzita detekovanych maxim (v pomeru k
%                  absolutnimu maximu (0; 1>
%       nPaks    - nejvyssi pocet maxim, ktera detekovat
%
%    Parametr Data muze mit vice rozmeru (napr. z kamery). Vystupem je pak
%    matice stejnych rozmeru jako rozliseni snimace obsahujici zjistene
%    polohy stredu interferencnich prouzku.
%
%    Pro ladeni (zobrazovani informaci o vypoctu a grafu pro overeni
%    funkcnosti) je treba upravit kod funkce a v kodu ladeni povolit.
%

% Povoleni ladeni (vykresluje grafy a vypisuje informace) - true/false
% Pri povoleni ladeni nepouzivejte paralelni zpracovani (misto parfor nize
% pozijte cyklus for), v opacnem pripade nejsou grafy zobrazovany.
debug=false;

% Paralelni zpracovani je mozne povolit zamenou for za parfor nize
% Duvodem je, ze bez Parallel Computing Toolbox parfor nefunguje spravne,
% pri nedostupnosti tohoto Toolboxu by tedy nemusela tato funkce fungovat.

% zakazat upozorneni
warning('off','MATLAB:mir_warning_maybe_uninitialized_temporary');

% zmenit rozmery matice s daty (pokud neni 3D)
switch length(find(size(InData)>1))                                         % zjistit pocet rozmeru matice Data
    case 3                                                                  % zpracovavame data z 2D snimace
        Data=InData;
    case 2                                                                  % zpracovavame data z 1D snimace
        Data(:,1,:)=InData;
    case 1                                                                  % zpracovavame data z 1 bodu
        Data(1,1,:)=InData;
    otherwise
        error('Neplatny rozmer matice Data');                               % matici nelze zpracovat
end

% zjistit rozliseni a dalsi parametry
n = size(Data,3);                                                           % spocitat snimky
if n ~= length(Zax)
    error('Matice Data a vektor Zax nemaji stejnou delku.');
end
xRes = size(Data,1);                                                        % zjistit vodorovne rozliseni snimku
yRes = size(Data,2);                                                        % zjistit svisle rozliseni snimku
step = mean(diff(Zax));                                                     % urcit prumerny krok mezi snimky

% vypocitat povrch
povrch = zeros(xRes,yRes);                                                  % vyplnit matici nulami
%parfor i=1:xRes                                                             % pro paralelni zpracovani
for i=1:xRes                                                                % bez paralelniho zpracovani
    for j=1:yRes
        
        % najit priblizne prouzek pomoci maxima
        Signal=squeeze(Data(i,j,:));                                        % nacist signal pro zpracovani
        [MaxVal MaxInd]=max(abs(Signal-mean(Signal)));                      % vypocitat maximum
        Center=Zax(MaxInd);                                                 % poloha stredu
        IndMin=round(MaxInd-Delta/step);                                    % minimalni vzorek
        IndMax=round(MaxInd+Delta/step);                                    % maximalni vzorek
        if IndMin>IndMax; temp=IndMax; IndMax=IndMin; IndMin=temp; end;     % pokud je osa klesajici
        if IndMin<1; IndMin=1; end;                                         % pokud jsme mimo vzorky, zacit od kraje
        if IndMax>n; IndMax=n; end;                                         % pokud jsme mimo vzorky, koncit na kraji

        % data pro dalsi zpracovani jen kolem maxima
        IDetail=double(Signal(IndMin:IndMax))';                             % cast prouzku pro zpracovani
        ZaxDetail=Zax(IndMin:IndMax);                                       % cast osy z pro zpracovani
        
        % vypocet stredu prouzku
        IDetail = IDetail - mean(IDetail);                                  % odecteni stredni hodnoty
        [pksVal pksInd] = findpeaks(abs(IDetail),'MinPeakHeight',...
            max(IDetail)*minH,'MinPeakDistance',ceil(minD/step),...
            'SortStr','descend');                                           %najit maxima
        nPeaksI = min([length(pksInd) nPeaks]);                             % pocet maxim, ktera zpracovat
        pksPos = ZaxDetail(pksInd(1:nPeaksI));                              % vypocitat polohu maxim
        povrch(i,j) = dot(pksPos,pksVal(1:nPeaksI))/sum(pksVal(1:nPeaksI));% vypocitat vazeny prumer poloh maxim
        
        % ladeni
        if debug                                                            % pokud je povoleno ladeni
            % vypsat informace
            disp(sprintf('bod x=%i/%i, y=%i/%i',i,xRes,j,yRes));
            disp(sprintf('minD=%d um, delta=%d um',minD,Delta));
            disp(sprintf('pocet maxim: %d, z=%d um',length(pksVal(1:nPeaksI)),povrch(i,j)));
            
            % vykreslit grafy
            debugfig = figure(); set(gcf, 'Position', get(0,'Screensize')); hold on; % otevrit obrazek
            plot(Zax,(double(Signal)-mean(double(Signal))),'b');
            plot(ZaxDetail,IDetail,'r');
            plot(pksPos,pksVal(1:nPeaksI),'k.');
            plot([povrch(i,j) povrch(i,j)],[min(IDetail) max(IDetail)],'m--','LineWidth',3);
            xlim([Center-4*Delta Center+4*Delta]);
            xlabel('z/um'); ylabel('I');
            title(sprintf('Pro pokracovani kliknete na obrazek.\n\nbod x=%i/%i, y=%i/%i\nminD=%d um, delta=%d um\npocet maxim: %d, z=%d um',i,xRes,j,yRes,minD,Delta,length(pksVal(1:nPeaksI)),povrch(i,j)));
            legend('signal','zpracovano','maxima','detekovano');
            
            % cekat na uzivatele
            disp('Pro pokracovani kliknete na obrazek');                    % vypsat hlasku
            waitforbuttonpress;                                             % cekat na kliknuti
            close(debugfig);                                                % zavrit obrazek
        end
    end
end

% snizit rozmer matice s povrchem (neni-li matice Data 3D)
povrch=squeeze(povrch);

% povolit upozorneni
warning('off','MATLAB:mir_warning_maybe_uninitialized_temporary');

end