%% whitesim_fringe.m
%
% Ukazka modelu interferencniho prouzku v LCI
% 

close all; clear all; clc;                                                  % zavrit a smazat vse

%% Typ simulace

%  0 - nacist ze souboru spektrum (novy model)
%  1 - spektrum ma tvar Gaussovy funce (puvodni model)

gauss=0;


%% Nastaveni

% nastaveni pro LED
sfile = 'Data/LED.txt';                                                     % soubor s namerenym spektrem
file = 'Data/prouzek.lvm';                                                  % soubor s namerenym prouzkem (pro srovnani)
fc = 136.58;                                                                % stred namereneho prouzku (pro vykreleni)
c = 299792458;                       

% nastaveni pro gaussovske spektrum
Lambda0 = 460e-9;                                                           % stredni vlnova delka [m]
Ic = 2.5e-6;                                                                % koherencni delka [m]


%% Otevrit obrazek

figure(); set(gcf, 'Position', get(0,'Screensize'));


%% Spektrum

% vypocitat nebo nacist
if gauss
    f0 = c/Lambda0;                                                         % vypocitat stredni frekvenci
    Df = c/(pi*Ic);                                                         % vypocitat frekvencni sirku spektra
    f=linspace(c/160e-9,c/1260e-9,600);                                     % rozsah frekvenci
    S = 1/(sqrt(pi)*Df) * exp(- ((f-f0)./(Df)).^2 );                        % intenzita kazde z frenvenci
    Lambda = c./f;                                                          % prepocitat frekvence na vlnove delky
else
    Spectrum = dlmread(sfile);                                              % nacist spektrum ze souboru
    Lambda = Spectrum(:,1)*1e-9;                                            % v prvnim sloupci jsou vlnove delky
    Intens = Spectrum(:,2);                                                 % v druhem sloupci intenzity
    f = c./Lambda;                                                          % prepocitat vlnove delky na frekvenci
    S = Intens-min(Intens);                                                 % odecist od intenzity minimum
end

% vykreslit spektrum
subplot(4,1,1)
plot(f,S);
title('Spektrum');
xlabel('f [Hz]'); ylabel('I');



%% Model prouzku (intenzita)

% vypocitat
x = linspace(-5e-6,5e-6,2000);                                              % osa, na ktere se bude pocitat
y = zeros(length(f),length(x));
for i = 1:length(f)                                                         % pro kazdou frekvenci
    y(i,:) = cos(4.*pi.*f(i).*x./c).*S(i);                                  % spocitat intenzitu
end
I = sum(y);                                                                 % secist intenzity jednotlivych frekvenci
Inorm = (I-mean(I))./max((I-mean(I)));                                      % normovat (stredni hodnota bude 0, amplituda 1)

% vykreslit
subplot(4,1,2)
plot(x,Inorm,'r');
title('Model prouzku');
xlim([-5e-6 5e-6]); ylim([-1 1]);
xlabel('\Deltax [m]'); ylabel('I');



%% Skutecny prouzek

% vypocitat nebo nacist
data = importdata(file);                                                    % nacist soubor s prouzkem
xx = 1:length(data(:,2));                                                   % vytvorit osu
koef = polyfit(xx',data(:,3)-fc,1);                                         % polynom pro prolozeni polohy (pro odstraneni sumu)
poly = polyval(koef,xx);                                                    % vypocitat hodnoty polynomu
fri = data(:,4);                                                            % nacist prouzek
plyn = -(fri-mean(fri))./max((fri-mean(fri)));                               % normovat (stredni hodnota bude 0, amplituda 1)

% vykreslit
subplot(4,1,3)
plot(poly./1e6,plyn);
xlim([-5e-6 5e-6]); ylim([-1 1]);
title('Realny prouzek');
xlabel('\Deltax [m]'); ylabel('I');



%% Model prouzku (barevny)

% vypocitat barevny prouzek
color=spectrumRGB(Lambda.*1e9);                                             % zjistit RGB pro danou vlnovou delku
RGB = zeros(length(Lambda),length(x),3);
for i=1:length(Lambda)                                                      % pro kazdou vlnovou delku
    for j=1:length(x)                                                       % pro kazdy bod
        for k=1:3                                                           % pro kazdou barvu (R, G, B)
            RGB(i,j,k)=y(i,j)*color(1,i,k);                                 % vypocitat hodnotu RGB
        end
    end
end
RGB=sum(RGB);                                                               % secist hodnoty RGB pro vsechny vlnove delky
for k=1:3
    RGB(1,:,k)=RGB(1,:,k)-mean(RGB(1,:,k));
    RGB(1,:,k)=RGB(1,:,k)./(max(abs(RGB(1,:,k)))*2)+0.5;                    % normovani (imagesc potrebuje hodnoty 0<=x<=1)
end

% vykreslit barevny prouzek
subplot(4,1,4)
imagesc(RGB);
title('Barevny model');
xlabel('x [nm]');
