function [average uncertainty] = uncertaintyA(data,alpha)
%UNCERTAINTYA vypocita prumer a nejistotu typu A
%   
%    [prumer nejistota] = uncertaintyA(data,[alpha])
%       data     - hodnoty, ze kterych pocitat prumer a nejistotu
%       alpha    - hladina vyznamnosti (nepovinne, vychozi 0.05)
%

% parametry
if nargin==1                                                                % neni-li zadana hladina vyznamnosti
    alpha=0.05;                                                             % pouzit vychozi
end

% velikost dat
dataSize=size(data);                                                        
if min(dataSize)==1
    n=length(data);
else
    n=dataSize(1);
end

% vypocet
average=mean(data);                                                         % vypocitat prumer
uncertainty=std(data,0)/sqrt(n)*tinv(1-alpha/2,n-1);                        % vypocitat nejistotu

end