function xPos = interf2pos(PhSig,Lambda)
%INTERF2POS vypocita polohu pohybliveho zrcadla Michelsonova interferometru
%ze signalu na detektoru pomoci faze analytickeho signalu vytvoreneho
%Hilbertovou transformaci.
%   
%    poloha = interf2pos(signal, lambda)
%       signal   - signál z detektoru
%       lambda   - vlnova delka laseru
%
%    Pocatecni poloha je vzdy urcena jako 0, poloha vzdy roste.
%
%    Vzdy je treba splnit pozadavek, aby se zrcadlo pohybovalo pouze jednim
%    smerem a nedochazelo k prudkym zmenam rychlosti.
%
%    Poloha je vypocitana ve stejnych jednotkach, v jakych je zadana vlnova
%    delka.
%
%    Vzhledem ke zpusobu vypoctu jsou hodnoty vzdalene asi lambda/2 od zacatku
%    a od konce zadaneho sigalu vypocitany chybne, proto je treba mereni vzdy
%    spustit drive a vypnout pozdeji a okraje ignorovat.
%

% zjistit delku zaznamu
n    = length(PhSig);                                                       % spocitat snimky

% vypocitat prumerny signal z detektoru
FrAx = [1:n];
PhSigMeanC = polyfit(FrAx,PhSig,2);                                         % prolozit signal polynomem
PhSigMeanV = polyval(PhSigMeanC,FrAx);                                      % vypocitat prumer (menici se dle polynomu)

% normovat signal
PhSigCen = PhSig - PhSigMeanV;                                              % odecist od signalu prumer
PhSigNor = PhSigCen ./ max(abs(PhSigCen(10:n-10)));                         % normovat signal, pocatek a konec ignorovat

% vypocitat fazi a polohu
PhAng = unwrap(angle(hilbert(PhSigNor)));                                   % vypocitat fazi
xPos = PhAng.*(Lambda./(4*pi));                                             % vypocitat polohu
xPos = xPos-xPos(1);                                                        % odecist pocatek

end