function ExchangerTestScenerioTrace24012024 = importfile(filename, dataLines)
%IMPORTFILE Import data from a text file
%  EXCHANGERTESTSCENERIOTRACE24012024 = IMPORTFILE(FILENAME) reads data
%  from text file FILENAME for the default selection.  Returns the data
%  as a table.
%
%  EXCHANGERTESTSCENERIOTRACE24012024 = IMPORTFILE(FILE, DATALINES)
%  reads data for the specified row interval(s) of text file FILENAME.
%  Specify DATALINES as a positive scalar integer or a N-by-2 array of
%  positive scalar integers for dis-contiguous row intervals.
%
%  Example:
%  ExchangerTestScenerioTrace24012024 = importfile("C:\Users\Michal\OneDrive - VUT\Vymenik\vymenik_18_1_2024\vymenik_18_1_2024\vymenik_matlab\ExchangerTestScenerioTrace_24_01_2024.csv", [2, Inf]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 24-Jan-2024 18:24:19

%% Input handling

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [2, Inf];
end

%% Set up the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 9, "Encoding", "UTF-8");

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = ["Sample", "Xms14042012185047588UTC", "T1_DBVyslednaTeplota", "T2_DBVyslednaTeplota", "T3_DBVyslednaTeplota", "T4_DBVyslednaTeplota", "V1_DBNastav_hod", "V2_DBNastav_hod", "diBoilerRunI125"];
opts.VariableTypes = ["double", "double", "double", "double", "double", "double", "double", "double", "double"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Import the data
ExchangerTestScenerioTrace24012024 = readtable(filename, opts);

end