function Q = funkce (params)

params = 10.^params;


global timeVector;
global period;
global Y_m;

global Mp; Mp = params(1);
global Bp; Bp = params(2);
global Mb; Mb = params(3);
global Br; Br = params(4);
global Mr; Mr = params(5);
global Bx; Bx = params(6);
global Mx; Mx = params(7);
global Kh; Kh = params(8);
global P; P = params(9);


simConfig.Solver = "ode15s";

simConfig.StopTime = string((length(timeVector)-1)*period);

Sim = sim('vymeniksimulink.slx',simConfig);
Y_sim = Sim.teploty(:,2:5);



Q = sqrt(sum(sum((Y_m-Y_sim).^2))/(numel(Y_m))); % kriterium středná kvadratická odchylka


end