close all
clear
clc
clearvars
%% import dat

load('saveParam.mat')
disp("old params")
x0

%nacteni prubehu
offsetData = importfileCSV('Teplota_kompenzace_02_02_2024.csv');
scenerioData = importfileCSV('Teplota_220324.csv');   %treninkovy
%scenerioData = importfileCSV('Teplota_31_01_2024.csv'); %valid 1
%scenerioData = importfileCSV('Teplota_040424.csv'); % valid 2

global timeVector;


startIndex = 50;
stopIndex = size(scenerioData,1);

%% Cas vzorkovani
time = scenerioData.Xms14042012185047588UTC(startIndex:end);

dP = zeros(size(time,1)-1,1);
for i = 1:size(time,1)-1
    dP(i) = (time(i+1)-time(i))/1000;
end

figure(1);
hold on;
histogram(dP,25);
ylabel({'Počet period'});
xlabel({'Perioda [s]'});

sampleTime = 5;

% Kompenzace teploty
offsetStartIndex = 100;
offsetStopIndex = 8500;
offsetSignal = [offsetData.T1_DBVyslednaTeplota(offsetStartIndex:offsetStopIndex) ...
                offsetData.T2_DBVyslednaTeplota(offsetStartIndex:offsetStopIndex) ...
                offsetData.T3_DBVyslednaTeplota(offsetStartIndex:offsetStopIndex) ...
                offsetData.T4_DBVyslednaTeplota(offsetStartIndex:offsetStopIndex)];
globalMeanTemp = sum(sum(offsetSignal))/numel(offsetSignal);
comp = -((sum(offsetSignal)./length(offsetSignal))-globalMeanTemp);


timeVector = (scenerioData.Sample(startIndex:stopIndex)-startIndex+1)*sampleTime;

temp_1 = scenerioData.T1_DBVyslednaTeplota(startIndex:stopIndex)+comp(1);

temp_2 = scenerioData.T2_DBVyslednaTeplota(startIndex:stopIndex)+comp(2);

temp_3 = scenerioData.T3_DBVyslednaTeplota(startIndex:stopIndex)+comp(3);

temp_4 = scenerioData.T4_DBVyslednaTeplota(startIndex:stopIndex)+comp(4);

valve1 = [timeVector, scenerioData.V1_DBNastav_hod(startIndex:stopIndex)./100];
valve2 = [timeVector, scenerioData.V2_DBNastav_hod(startIndex:stopIndex)./100];

boiler = [timeVector, scenerioData.diBoilerRunI125(startIndex:stopIndex)];





%% Globalni simulacni parametry

% Teplota okoli
global Tamb; Tamb = 24;

% Teplotni vodivost H2O
global C; C = 4180;

% Inicializace namerenych teplot
global T1_0; T1_0 = temp_1(1,1);
global T2_0; T2_0 = temp_2(1,1);
global T3_0; T3_0 = temp_3(1,1);
global T4_0; T4_0 = temp_4(1,1);

% Inicializace teploty skrytych stavu 
% (bude odhadnuto optimalizačním procesem)
global T5_0; T5_0 = 75;     % mereni zacina s nahratou vodou
global T6_0; T6_0 = T2_0;
global T7_0; T7_0 = T4_0;
global T8_0; T8_0 = T3_0;

%% Inicializace parametru
%nalezene parametry
vykres = [0.126544704258919,0.109478504056406,1.48345256486252,0.12372212347546,0.0770414186029129,9.37845765388208,0.00114882175555545,5.90082453879861,206.292727095294];


if 1
    % Element potrubi parametry
    %global Mp; Mp = 0.5;
    %global Bp; Bp = 0.3;
    
    % Prutokovy ohrivac vody parametry
    %global Mb; Mb = 1;      
    
    %Radiator parametry
    %global Br; Br = 0.2;
    %global Mr; Mr = 0.1;
    
    % Element vymeniku parametry
    %global Bx; Bx = 0.5;
    %global Mx; Mx = 0.5;
    
    % Prutokovy ohrivac vody dynamika
    %global Kh; Kh = 30
    %global P; P = 2000

    % Element potrubi parametry
    global Mp; Mp = vykres(1)
    global Bp; Bp = vykres(2);
    
    % Prutokovy ohrivac vody parametry
    global Mb; Mb = vykres(3);      
    
    % Radiator parametry
    global Br; Br = vykres(4);
    global Mr; Mr = vykres(5);
    
    % Element vymeniku parametry
    global Bx; Bx = vykres(6);
    global Mx; Mx = vykres(7);
    
    % Prutokovy ohrivac vody dynamika
    global Kh; Kh = vykres(8);
    global P; P = vykres(9)

else
    % Element potrubi parametry
    global Mp; Mp = x0(1);
    global Bp; Bp = x0(2);
    
     % Prutokovy ohrivac vody parametry
    global Mb; Mb = x0(3);
    
    % Radiator parametry
    global Br; Br = x0(4);
    global Mr; Mr = x0(5);

    % Element vymeniku parametry
    global Bx; Bx = x0(6);
    global Mx; Mx = x0(7);

    % Prutokovy ohrivac vody dynamika
    global Kh; Kh = x0(8);
    global P; P = x0(9)
end



% Perioda vzorkovani
global period; period= sampleTime; % (s)

% Namerene teploty
global Y_m; Y_m = [temp_1,temp_2,temp_3,temp_4];

%% Nastaveni simulace

simConfig.Solver = "ode15s";

simConfig.StopTime = string((length(timeVector)-1)*period);

Sim = sim('vymeniksimulink.slx',simConfig);



Y_sim = Sim.teploty(:,2:5);


Q = sqrt(sum(sum((Y_m-Y_sim).^2))/(numel(Y_m))); % kriterium středná kvadratická odchylka


x0 = log10([Mp,Bp,Mb,Br,Mr,Bx,Mx,Kh,P]); % input vector
%%

%fminsearch
opts=optimset('PlotFcns',@optimplotfval,'MaxIter',500);
Opt_param = fminsearch(@funkce,x0,opts);




Sim = sim('vymeniksimulink.slx',simConfig);

Y_sim = Sim.teploty(:,2:5);

%vykresleni prubehu
figure

plot (timeVector,Y_m(:,1),'r');

hold on 
plot(timeVector,Y_m(:,2),'g');
plot(timeVector,Y_m(:,3),'b');
plot(timeVector,Y_m(:,4),'black');
plot (timeVector,Y_sim(:,1),'--r');
plot(timeVector,Y_sim(:,2),'--g');
plot(timeVector,Y_sim(:,3),'--b');
plot(timeVector,Y_sim(:,4),'--black');
yyaxis right
plot(timeVector,valve1(:,2));
plot(timeVector,valve2(:,2)+0.01);
plot(timeVector,boiler(:,2)+0.02);





legend ('T_1','T_2','T_3','T_4','T_1s','T_2s','T_3s','T_4s');
xlabel('t [s]');
ylabel('T [^{°}C]')



disp("new params")

x0 = 10.^Opt_param;

x1 = x0
save('saveParam.mat','x0');

