#ifndef XARM_H
#define XARM_H

#include <stdint.h>

#define DBG 0

enum commands { 
	COMMAND_MOVE,
	COMMAND_ROTATE,
	COMMAND_PICK_UP,
	COMMAND_PUT_DOWN,
	COMMAND_CHANGE_NIXIE_TYPE,
	COMMAND_START_CALIBRATION,
	COMMAND_STOP_CALIBRATION,
	COMMAND_CHANGE_CALIBRATION,
	NUM_OF_COMMANDS
};

const uint8_t commandLength[NUM_OF_COMMANDS] = {3, 2, 1, 1, 2, 3, 1, 3};

class xArm {
	public:
		void init();
		void poll();
		bool interfaceAvailable();
		bool sendCommand(uint8_t command, uint8_t param1 = 0, uint8_t param2 = 0);
		bool commandSuccess();
		bool returnVal();
		bool taskRunning = false;
};

#endif