#ifndef PLC_H
#define PLC_H

#include <stdint.h>

// variables shared between PLC and HMI

// current aging state
enum agingStates {
	AGING_STATE_IDLE,
	AGING_STATE_RUNNING,
	AGING_STATE_PAUSED,
	AGING_STATE_ERROR
};
extern agingStates agingState;

// current aging substate
enum agingSubstates {
	AGING_SUBSTATE_FILLING,
	AGING_SUBSTATE_EMPTYING,
	AGING_SUBSTATE_CYCLE_1,
	AGING_SUBSTATE_CYCLE_2,
	AGING_SUBSTATE_HG_RELEASE
};
extern agingSubstates agingSubstate;

// current nixie
enum nixieTypes {
	NIXIE_R,
	NIXIE_F
};
extern nixieTypes nixieType;

// aging commands
extern void startAging(int8_t substateType);
extern void stopAging();
extern void pauseAging();
extern void resumeAging();

// nixie type change
extern void changeNixieType(uint8_t type);

#endif
