/**
 * @file    tim_tms320f28069.h
 * @author  Matej Turinsky
 * @date    12. 3. 2024
 * @brief   Header file for the TMS320F28069 timer driver.
 */

#pragma once

#ifndef TIM_TMS320F28069_H_
#define TIM_TMS320F28069_H_

#include <stdint.h>
#include "F2806x_Device.h"
#include "devio.h"

/**
 * Timer instance definition macro for driver configuration
 */
#define TIM_INSTANCE(_ctrlReg)          \
        {                               \
            .pOcCtrlReg = _ctrlReg,     \
            .pIcCtrlReg = NULL          \
        }

// TODO
//#define TIM_OC_INSTANCE(_ocCtrlReg)     \
//        {                               \
//            .pOcCtrlReg = _ocCtrlReg,   \
//            .pIcCtrlReg = NULL          \
//        }

// TODO
//#define TIM_IC_INSTANCE(_icCtrlReg)     \
//        {                               \
//            .pOcCtrlReg = NULL,         \
//            .pIcCtrlReg = _icCtrlReg    \
//        }

/**
 * Timer structure for the TMS320F28069.
 */
typedef struct EPWM_REGS* const pTimOutCompReg_t;
typedef struct ECAP_REGS* const pTimInCapReg_t;

typedef struct {
    pTimOutCompReg_t pOcCtrlReg;    ///< ePWM peripheral = timing and output compare
    pTimInCapReg_t pIcCtrlReg;      ///< eCAP peripheral = input capture

    io_callback_t overflowCallback;         // time-base counter overflow callback (or NULL when unused)
    io_callback_t captureCompareCallback;   // ePWM or eCap callback (or NULL when unused)
} tim_dev_t;

/**
 * Timer register to pointer casting macros (use these in 'conf_driver.h')
 */
#define TIM_CTRL_REG_CAST(reg)      (pTimOutCompReg_t)(void*)(&reg)
#define TIM_OC_CTRL_REG_CAST(reg)   (pTimOutCompReg_t)(void*)(&reg)
#define TIM_IC_CTRL_REG_CAST(reg)   (pTimInCapReg_t)(void*)(&reg)


#endif /* TIM_TMS320F28069_H_ */
