/**
 * @file    i2c_tms320f28069.h
 * @author  Matej Turinsky
 * @date    5. 4. 2024
 * @brief   Header file for the TMS320F28069 I2C driver.
 */

#pragma once

#ifndef I2C_TMS320F28069_H_
#define I2C_TMS320F28069_H_

#include <stdint.h>
#include "F2806x_Device.h"

/**
 * I2C instance definition macro for driver configuration.
 */
#define I2C_INSTANCE(_ctrlReg, _selfSlaveAddress, _sdaPort, _sdaPin, _sclPort, _sclPin)     \
        {                                                                                   \
            .pCtrlReg = _ctrlReg,                                                           \
            .pSelfSlaveAddress = _selfSlaveAddress,                                         \
            .pSdaPort = _sdaPort,                                                           \
            .sdaPin = _sdaPin,                                                              \
            .pSclPort = _sclPort,                                                           \
            .sclPin = _sclPin                                                               \
        }

/**
 * I2C structure for the TMS320F28069.
 */
typedef struct I2C_REGS* const pI2cCtrlReg_t;
typedef struct GPIO_CTRL_REGS* const pI2cPortCtrlReg_t;

typedef struct {
    pI2cCtrlReg_t pCtrlReg;
    const uint16_t* const pSelfSlaveAddress;

    pI2cPortCtrlReg_t pSdaPort;
    const uint16_t sdaPin;
    pI2cPortCtrlReg_t pSclPort;
    const uint16_t sclPin;
} i2c_dev_t;

/**
 * I2C register to pointer casting macros (use these in 'conf_driver.h')
 */
#define I2C_CTRL_REG_CAST(reg)              (pI2cCtrlReg_t)(void*)(&reg)
#define I2C_SELF_SLAVE_ADDRESS_CAST(var)    (const uint16_t* const)(void*)(&var)
#define I2C_SDA_PORT_REG_CAST(reg)          (pI2cPortCtrlReg_t)(void*)(&reg)
#define I2C_SCL_PORT_REG_CAST(reg)          (pI2cPortCtrlReg_t)(void*)(&reg)

#endif /* I2C_TMS320F28069_H_ */
