/**
 * @file    host_config.h
 * @author  Matej Turinsky
 * @date    22.03.2024
 * @brief   Cores configuration file for MT-SD11.
 */

#pragma once

#ifndef HOST_CONFIG_H_
#define HOST_CONFIG_H_

// Clock source defines
#define USE_INT_OSC1        (1) ///< Internal oscillator 1
#define USE_INT_OSC2        (0) ///< Internal oscillator 2
#define USE_XTAL_OSC        (0) ///< Crystal oscillator
#define USE_EXT_OCS         (0) ///< External oscillator

// PLL config defines (CLK = OCSx * PLL_MULTIPLIER / PLL_DIVIDER)
#define PLL_MULTIPLIER      18
#define PLL_DIVIDER         2


// Calibration define
#define PERFORM_DEVICE_CALL (0) ///< Perform only when ROM boot is skipped


// Flash usage define
#define USE_PROG_FLASH      (0) ///< Enable when using Flash


// Serial debug use
#define USE_SERIAL_DEBUG    (1) ///< Enable debug prints over uart_serialPort


// CLA debug enable define
#define CLA_TASK1_BREAKPOINT    (0) ///< Add breakpoints to CLA current/voltage process task
#define CLA_TASK2_BREAKPOINT    (0) ///< Add breakpoints to CLA solar irradiance process task
#define CLA_TASK8_BREAKPOINT    (0) ///< Add breakpoints to CLA intialization task

// ADC-CLA channels
#define ADC_CLA_VA_INPUT_CHANNEL        0
#define ADC_CLA_IRR_INPUT_CHANNEL       2

// ADC-CLA conversion rates
#define ADC_CLA_REF_VOLTAGE             3.3f
#define ADC_CLA_INPUT_GAIN_VOLTAGE      1.0f
#define ADC_CLA_INPUT_OFFSET_VOLTAGE    0.0f
#define ADC_CLA_INPUT_GAIN_CURRENT      1.0f
#define ADC_CLA_INPUT_OFFSET_CURRENT    0.0f
#define ADC_CLA_INPUT_GAIN_IRRADIANCE   1.0f
#define ADC_CLA_INPUT_OFFSET_IRRADIANCE 0.0f

#define ADC_CLA_CONV_POWER_IRRADIANCE   -1.591f
#define ADC_CLA_CONV_MULT_IRRADIANCE    133.41f

// ADC-CLA arc filters
#define ADC_CLA_NUM_OF_ARC_FILTERS_TO_DETECT    4U
#define ADC_CLA_ARC_FILTER_AMPLITUDE_TRESHOLD   0.01f
#include "adc_cla_arc_filter_coeficient.h"

// ADC-CLA buffers
#define ADC_CLA_VA_IN_DELAY_LINE_LENGTH     (ADC_CLA_LEN_OF_ARC_FILTERS)
#define ADC_CLA_VA_OUT_DELAY_LINE_LENGTH    (ADC_CLA_LEN_OF_ARC_FILTERS)
#define ADC_CLA_IRR_IN_DELAY_LINE_LENGTH    8UL
#define ADC_CLA_VA_CURRENT_POS              0   ///< current index in result buffer
#define ADC_CLA_VA_VOLTAGE_POS              1   ///< voltage index in result buffer


// I2C sensor slave addresses
#define I2C_ADDRESS_TEMPERATURE_PANEL       0b1001000
#define I2C_ADDRESS_TEMPERATURE_AMBIENT     0b1001000


// Disconnectors {Positive, Negative} GPIOA pins
#define GPIOA_PINS_DISCONECTORS     {16, 17}

// Shorting relays {Relay1, ..., Relay16} GPIO pins (-1 = unused)
#define GPIOA_PINS_SHORT_RELAYS     {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}

// Differential current sensor GPIOA pin
#define GPIOA_PIN_DIFF_CURRENT      18


// nanoMODBUS build configuration
#define NMBS_CLIENT_DISABLED
#define NMBS_SERVER_WRITE_SINGLE_COIL_DISABLED
#define NMBS_SERVER_WRITE_SINGLE_REGISTER_DISABLED
#define NMBS_SERVER_READ_FILE_RECORD_DISABLED
#define NMBS_SERVER_WRITE_FILE_RECORD_DISABLED
#define NMBS_SERVER_READ_WRITE_REGISTERS_DISABLED
#define NMBS_SERVER_READ_DEVICE_IDENTIFICATION_DISABLED

#define NMBS_DEBUG              ///< should be disabled to lower .cio footprint
#define NMBS_STRERROR_DISABLED  ///< should be disabled to lower .cio footprint

// nanoMODBUS application configuration
#define NMBS_RTU_ADDRESS        1U
#define NMBS_READ_TIMEOUT       10UL
#define NMBS_BYTE_TIMEOUT       1UL


#endif /* HOST_CONFIG_H_ */
