/**
 * @file    gpio_tms320f28069.h
 * @author  Matej Turinsky
 * @date    23. 2. 2024
 * @brief   Header file for the TMS320F28069 GPIO driver.
 */

#pragma once

#ifndef GPIO_TMS320F28069_H_
#define GPIO_TMS320F28069_H_

#include <stdint.h>
#include "F2806x_Device.h"

/**
 * GPIO instance definition macro for driver configuration
 */
#define GPIO_INSTANCE(_ctrlReg, _dataReg, _mask)    \
        {                                           \
            .pCtrlReg = _ctrlReg,                   \
            .pDataReg = _dataReg,                   \
            .mask = _mask,                          \
        }

/**
 * GPIO structure for the TMS320F28069.
 */
typedef struct GPIO_CTRL_REGS* const pGpioCtrlReg_t;
typedef struct GPIO_DATA_REGS* const pGpioDataReg_t;

typedef struct {
    pGpioCtrlReg_t pCtrlReg;
    pGpioDataReg_t pDataReg;
    const uint32_t mask;
} gpio_dev_t;

/**
 * GPIO register to pointer casting macros (use these in 'conf_driver.h')
 */
#define GPIO_CTRL_REG_CAST(reg)    (pGpioCtrlReg_t)(void*)(&reg)
#define GPIO_DATA_REG_CAST(reg)    (pGpioDataReg_t)(void*)(&reg)

#endif /* GPIO_TMS320F28069_H_ */
