/**
 * @file    core-mt-plc-sem1-config.h
 * @author  Roman Mego
 * @date    20. 2. 2024
 * @brief   Driver configuration file for STM32F4xx variant of MT-PLC-SEM1 core
 */

#pragma once

#ifndef CORE_MT_PLC_SEM1_CONFIG_H_
#define CORE_MT_PLC_SEM1_CONFIG_H_

#define USE_WD_DRIVER                       1
#define USE_RANDOM_DRIVER                   1
#define USE_RTC_DRIVER                      1
#define USE_GPIO_DRIVER                     1
#define USE_UART_DRIVER                     1
#   define UART_DEFAULT_BAUDRATE            115200
#   define UART1_BUFFER_SIZE                2048
#   define UART2_BUFFER_SIZE                8192
#   define UART3_BUFFER_SIZE                128
#define USE_I2C_DRIVER                      1
#define USE_SPI_DRIVER                      1
#define USE_I2CMEM_DRIVER                   1
#define USE_AT25SF_DRIVER                   1
#define USE_SM2400G3_DRIVER                 1
#   define SM2400G3_TASKS_MAX_PRIORITY      (configMAX_PRIORITIES - 1)
#   define SM2400G3_COORDINATOR_SUPPORT     1
#   define SM2400G3_RANDOM_DEVICE           "/dev/random"
#   define SM2400G3_DATABUFFER_SIZE         UART2_BUFFER_SIZE
#define USE_SM2400G3PHY_DRIVER              1
#define USE_SM2400LOADER_DRIVER             1

#define CORE_AVAILABLE_DEVICES                                                  \
    DEVICE("/dev/wdog0",  wd,       0),      /* Internal watchdog           */  \
    DEVICE("/dev/rtc",    rtc,      0),      /* RTC and backup memory       */  \
    DEVICE("/dev/random", random,   0),      /* Random number generator     */  \
    DEVICE("/dev/io0",    gpio,     0),      /* SM2400 RESET + BOOT         */  \
    DEVICE("/dev/io1",    gpio,     1),      /* SM2400 HOSTREQ, PLC Att.    */  \
    DEVICE("/dev/gpio0",  gpio,     2),      /* GPIOA                       */  \
    DEVICE("/dev/gpio1",  gpio,     3),      /* GPIOB                       */  \
    DEVICE("/dev/gpio2",  gpio,     4),      /* GPIOC                       */  \
    DEVICE("/dev/gpio3",  gpio,     5),      /* GPIOD                       */  \
    DEVICE("/dev/uart0",  uart,     0),      /* Primary UART            */  \
    DEVICE("/dev/uart1",  uart,     1),      /* Service UART            */  \
    DEVICE("/dev/uart2",  uart,     2),      /* SM2400 UART             */  \
    DEVICE("/dev/spi0",   spi,      0),      /* SM2400 SPI              */  \
    DEVICE("/dev/spi1",   spi,      1),      /* Flash SPI               */  \
    DEVICE("/dev/i2c0",   i2c,      0),      /* I2C                     */  \
    DEVICE("/dev/mtd0",   at25sf,   0),      /* Flash memory            */  \
    DEVICE("/dev/mtd1",   i2cmem,   0),      /* EEPROM                  */  \
    DEVICE("/dev/plc0-asl",    sm2400g3, 0),    /* SM2400 PLC modem     */  \
    DEVICE("/dev/plc0-phy",    sm2400g3phy, 0), /* SM2400 PLC modem     */  \
    DEVICE("/dev/plc0-loader", sm2400loader, 0) /* SM2400 loader        */

#define AVAILABLE_WD_DEVICES            \
    WD_INSTANCE(0x07, 0x0FFFF)

#define AVAILABLE_RTC_DEVICES           \
    RTC_INSTANCE()

#define AVAILABLE_RANDOM_DEVICES        \
    RANDOM_INSTANCE()

#define AVAILABLE_GPIO_DEVICES                                                              \
    GPIO_INSTANCE(GPIOB, (1 << 1) | (1 << 5)),  /* SM2400 RESET = PB1, BOOT = PB5       */  \
    GPIO_INSTANCE(GPIOC, (1 << 4) | (1 << 9)),  /* SM2400 HOSTREQ = PC4, PLC Att. = PC9 */  \
    GPIO_INSTANCE(GPIOA, (1 << 8)),             /* GPIOA                                */  \
    GPIO_INSTANCE(GPIOB, (1 << 8) | (1 << 9)),  /* GPIOB                                */  \
    GPIO_INSTANCE(GPIOC, (1 << 0) | (1 << 1) | (1 << 2) | (1 << 3) | (1 << 5) | (1 << 6) | (1 << 7) | (1 << 8) | (1 << 9) | (1 << 10) | (1 << 11) | (1 << 12)), /* GPIOC */ \
    GPIO_INSTANCE(GPIOD, (1 << 2)),             /* GPIOD                                */

#define AVAILABLE_UART_DEVICES                                                                                                          \
    UART_INSTANCE(USART2, GPIOA,  3, GPIOA,  2, GPIOA, 1, GPIOA, 0, GPIOB, 0, buffer_uart2, UART2_BUFFER_SIZE), /* Primary UART     */  \
    UART_INSTANCE(USART3, GPIOB, 11, GPIOB, 10, NULL, 0, NULL, 0, NULL, 0, buffer_uart3, UART3_BUFFER_SIZE),    /* Service UART     */  \
    UART_INSTANCE(USART1, GPIOA, 10, GPIOA,  9, NULL, 0, NULL, 0, NULL, 0, buffer_uart1, UART1_BUFFER_SIZE)     /* SM2400 UART      */

#define AVAILABLE_I2C_DEVICES                                               \
    I2C_INSTANCE(I2C1, 400000, GPIOB, 7, GPIOB, 6)  /* External I2C */

#define AVAILABLE_SPI_DEVICES                                               \
    SPI_INSTANCE(SPI1, STM32_SPI_MODE_3, 1000000, GPIOA,  6, GPIOA,  7, GPIOA,  5, GPIOA, (1 << 4)),    /* SM2400 SPI   */  \
    SPI_INSTANCE(SPI2, STM32_SPI_MODE_0, 50000000, GPIOB, 14, GPIOB, 15, GPIOB, 13, GPIOB, (1 << 12))   /* Flash SPI    */

#define AVAILABLE_I2CMEM_DEVICES                                            \
    I2CMEM_GENERAL_INSTANCE("/dev/i2c0", 0x50, 256, 16, 1)  /* 24AA025E64 */

#define AVAILABLE_AT25SF_DEVICES                                            \
    AT25SF041_INSTANCE("/dev/spi1", 12)

#define AVAILABLE_SM2400G3_DEVICES                                          \
    SM2400G3_INSTANCE("/dev/uart2", NULL, "/dev/rtc", 0, 0, 0)

#define AVAILABLE_SM2400G3PHY_DEVICES                                       \
    SM2400G3PHY_INSTANCE("/dev/uart2", NULL, 0, 0, 0, 0)

#define AVAILABLE_SM2400LOADER_DEVICES                                      \
    SM2400LOADER_INSTANCE("/dev/uart2", "/dev/io0", (1 << 1), 0, (1 << 5), 0)

#endif /* CORE_MT_PLC_SEM1_CONFIG_H_ */
