/**
 * @file    core-driver-config.h
 * @author  Roman Mego
 * @date    15. 11. 2023
 * @brief   Driver configuration file for MT-PLC-SEMx core.
 */

#pragma once

#ifndef CORE_DRIVER_CONFIG_H_
#define CORE_DRIVER_CONFIG_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <stdint.h>

#if defined(MT_PLC_SEM1)
#   include "core-mt-plc-sem1-config.h"
#elif defined(MT_PLC_SEM2)
#   include "core-mt-plc-sem2-config.h"
#else
#   error "Unsupported MT-PLC-SEMx core."
#endif

#define AVAILABLE_DEVICES   CORE_AVAILABLE_DEVICES

extern uint8_t buffer_uart1[];
extern uint8_t buffer_uart2[];
extern uint8_t buffer_uart3[];

#if defined(__cplusplus)
}
#endif

#endif /* CORE_DRIVER_CONFIG_H_ */
