/**
 * @brief   conn-keep.h
 * @author  Roman Mego
 * @date    12. 2. 2024
 * @brief   Network connection keeper.
 */

#pragma once

#ifndef INCLUDE_CONN_KEEP_H_
#define INCLUDE_CONN_KEEP_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <modemtec/plc-core/plc.h>

struct connkeep_settings
{
    plc_panid_t panid;
    plc_role_t role;
    unsigned int check_time;
};

typedef struct connkeep_settings connkeep_settings_t;

int connkeep_init(void);

int connkeep_start(const connkeep_settings_t* settings);

int connkeep_stop(void);

#if defined(__cplusplus)
}
#endif

#endif /* INCLUDE_CONN_KEEP_H_ */
