close all;
clear;
clc;

% ----------------------------------------------------------------------- %
showSpectrum = true;
showFiltering = true;

order = 8;
fs = 500; % kHz
fp = [30, 45, 60, 75, 90, 105, 120, 135]; % kHz
fd = 5; %kHz
type = "IIR - Butterworth";
% type = "IIR - Čebyšev typ 1";
% type = "IIR - Čebyšev typ 2";
% type = "IIR - Eliptický";

% ----------------------------------------------------------------------- %
dir = [];
file1 = [];
file2 = [];

dir = [dir, "measurements\Data_14_02_2024\Oblouk_bez_stridace\"];
file1 = [file1, "scope_1_kratky_oblouk_data.csv"];
file1 = [file1, "scope_2_stredni_oblouk_data.csv"];
file1 = [file1, "scope_3_dlouhy_oblouk_data.csv"];
file1 = [file1, "scope_4_start_oblouku_data_1.csv"];
file1 = [file1, "scope_5_start_oblouku_data_2.csv"];
dir = [dir, "measurements\Data_14_02_2024\Stridac_panely_bez_oblouku\"];
file2 = [file2, "scope_1_stridac_vystup_data.csv"];
file2 = [file2, "scope_2_stridac_vystup_data.csv"];
file2 = [file2, "scope_3_stridac_vystup_data.csv"];
file2 = [file2, "scope_4_proud_DC_data.csv"];
file2 = [file2, "scope_5_proud_DC_data.csv"];
file2 = [file2, "scope_6_proud_DC_data.csv"];

% ----------------------------------------------------------------------- %
if showSpectrum
    for i = 1:size(dir,2)
    figure(i);
    if i == 1
        file = file1;
    elseif i == 2
        file = file2;
    end

        for ii = 1:size(file,2)
            % Get path to data file
            path = dir(i) + file(ii);
        
            % Read data header
            header = readlines(path);
            header = header(1:2);
            header = split(header, ',');
            if header(1,1) == "x-axis"
                x_axis = str2double(header(1,2));
                if x_axis == 1
                    y_axis = 2;
                else
                    y_axis = 1;
                end
            
            elseif header(1,1) == "y-axis"
                y_axis = str2double(header(1,2));
                if y_axis == 1
                    x_axis = 2;
                else
                    x_axis = 1;
                end
            
            else
                disp("Corrupted header")
                return
            
            end
            
            % Read measurements
            data = readmatrix(path);
            data = data(3:end,:);
            x_time = data(:, x_axis);
            y_time = data(:, y_axis);
            
            % Compute frequency spectrum
            sampling_freq = 1 / (max(abs(x_time(1:2))) - min(abs(x_time(1:2))));
            signal_length = size(x_time, 1);
            x_freq = (sampling_freq / signal_length) * (0:(signal_length/2))';
            y_freq = (1/signal_length) * abs(fft(y_time));
            y_freq = y_freq(1:(signal_length/2 + 1));
             
            % Plot data in time and frequency domain
            subplot(size(file,2), 2, (2*ii)-1)
              plot(x_time, y_time);
              title("Časová doména")
              xlabel("t [s]")
              ylabel("I [A]")
            subplot(size(file,2), 2, 2*ii)
              plot(x_freq, y_freq);
              title("Frekvenční doména")
              xlabel("f [Hz]")
              ylabel("I [A]")
              if ii == 1
                  xlim([0, 200000])
                  ylim([0, 0.001])
              end
        end

    end

end %showSpectrum

if showFiltering
    figure(10)
    num = [];
    den = [];
    labels = [];
    for i = 1:size(fp,2)
        band = [fp(i)-fd, fp(i)+fd];
        if type == "IIR - Butterworth"
            [b, a] = butter(round(order/2), band/(fs/2), "bandpass");
        elseif type == "IIR - Čebyšev typ 1"
            [b, a] = cheby1(round(order/2), band/(fs/2), "bandpass");
        elseif type == "IIR - Čebyšev typ 2"
            [b, a] = cheby2(round(order/2), band/(fs/2), "bandpass");
        elseif type == "IIR - Eliptický"
            [b, a] = ellip(round(order/2), band/(fs/2), "bandpass");
        else
            quit("Unknown filter type..")
        end
        
        labels = [labels, "propust č." + num2str(i) + ": " + ...
                  num2str(band(1)) + "-" + num2str(band(2)) + " kHz"];
        [y, x] = freqz(b,a);
        y = 20*log10(abs(y));
        x = (fs/2)*(x/pi);
        plot(x,y)
        xlabel("f [kHz]")
        ylabel("A [dB]")
        xlim([0 fs])
        ylim([-60 0])
        legend(labels)
        title("Použitý filtr: " + type)
        grid on
        hold on

        num = [num; b];
        den = [den; a];

    end

    % Save filter coeficients to file
    textPath = "adc_cla_arc_filter_coeficient.h";
    textFile = fopen(textPath, "w");

    fprintf(textFile, "#define ADC_CLA_NUM_OF_ARC_FILTERS");
    fprintf(textFile, "\t%dU \n", size(num,1));
    fprintf(textFile, "#define ADC_CLA_LEN_OF_ARC_FILTERS");
    fprintf(textFile, "\t%dU \n\n", size(num,2));

    fprintf(textFile, "#define ADC_CLA_ARC_FILTER_NUM_COEFFICIENT");
    fprintf(textFile, " \\\n{ \\\n");
    for i = 1:size(num,1)
        fprintf(textFile, "\t{");
        fprintf(textFile, "%ff, ", num(i,1:end-1));
        fprintf(textFile, "%ff", num(i,end));
        if i == size(num,1)
            fprintf(textFile, "} \\\n");
        else
            fprintf(textFile, "}, \\\n");
        end
    end
    fprintf(textFile, "} \n\n");

    fprintf(textFile, "#define ADC_CLA_ARC_FILTER_DEN_COEFFICIENT");
    fprintf(textFile, " \\\n{ \\\n");
    for i = 1:size(den,1)
        fprintf(textFile, "\t{");
        fprintf(textFile, "%ff, ", den(i,1:end-1));
        fprintf(textFile, "%ff", den(i,end));
         if i == size(num,1)
            fprintf(textFile, "} \\\n");
        else
            fprintf(textFile, "}, \\\n");
        end
    end
    fprintf(textFile, "}\n");

    fclose(textFile);

    % Set path to data file
    path = ["measurements\Data_14_02_2024\Oblouk_bez_stridace\" + ...
           "scope_4_start_oblouku_data_1.csv";
           "measurements\Data_14_02_2024\Stridac_panely_bez_oblouku\" + ...
           "scope_5_proud_DC_data.csv"
           ];

    
    for i = 1:size(path,1)
        figure(10+i)
        
        % Read measurements
        data = readmatrix(path(i));
        data = data(3:end,:);
        x_time = data(:, x_axis);
        y_time = data(:, y_axis);

        for ii = 1:size(num,1)
            % Apply filter
            y_filtered = filter(num(ii,:), den(ii,:), y_time);
            
            % Plot filtered data in time domain
            subplot(round(size(num,1)/2)+2, 2, ii+2)
              plot(x_time, y_filtered);
              title(labels(ii))
              xlabel("t [s]")
              ylabel("I [A]")
              xlim([x_time(1) x_time(end)])
              if i == 1
                  ylim([-0.005, 0.005])
              elseif i == 2
                  ylim([-0.02, 0.02])
              end

        end
        
        % Compute frequency spectrum
        sampling_freq = 1 / (max(abs(x_time(1:2))) - min(abs(x_time(1:2))));
        signal_length = size(x_time, 1);
        x_freq = (sampling_freq / signal_length) * (0:(signal_length/2))';
        y_freq = (1/signal_length) * abs(fft(y_time));
        y_freq = y_freq(1:(signal_length/2 + 1));
        
        % Plot original data in time and frequency domain
        subplot(round(size(num,1)/2)+2, 2, 1)
          plot(x_time, y_time);
          title("Časová doména")
          xlabel("t [s]")
          ylabel("I [A]")
          xlim([x_time(1) x_time(end)])
        subplot(round(size(num,1)/2)+2, 2, 2)
          plot(x_freq, y_freq);
          title("Frekvenční doména")
          xlabel("f [Hz]")
          ylabel("I [A]")
          xlim([0, 200000])
          if i == 1
            ylim([0, 0.001])
          elseif i == 2
            ylim([0, 0.01])
          end
    end

end %showFiltering