/**
 * @file    cla_shared.h
 * @author  Matej Turinsky
 * @date    8. 3. 2024
 * @brief   Header file with CLA-CPU shared resources
 */

#pragma once

#ifndef CLA_SHARED_H_
#define CLA_SHARED_H_

#include <stdint.h>

#include "host_config.h"


/**
 * User defined CLA shared variables
 */
extern float adcCla_VAResult[2];                                    ///< adcClaVAProcessTask() return values - current & voltage
extern float adcCla_VAInput[2][ADC_CLA_VA_IN_DELAY_LINE_LENGTH];    ///< adcClaVAProcessTask() input values - buffer with last current & voltage samples
extern float adcCla_VAOutput[ADC_CLA_VA_OUT_DELAY_LINE_LENGTH];     ///< adcClaVAProcessTask() input values - buffer with last filtered current samples

extern float adcCla_arcFilterOutputs[ADC_CLA_NUM_OF_ARC_FILTERS];                               ///< IIR ADC arc filtered outputs
extern float adcCla_arcFilterNumCoefs[ADC_CLA_NUM_OF_ARC_FILTERS][ADC_CLA_LEN_OF_ARC_FILTERS];  ///< IIR ADC arc filter numerator coefficients
extern float adcCla_arcFilterDenCoefs[ADC_CLA_NUM_OF_ARC_FILTERS][ADC_CLA_LEN_OF_ARC_FILTERS];  ///< IIR ADC arc filter denominator coefficients

extern float adcCla_currentScale;   ///< ADC value to current scale
extern float adcCla_currentOffset;  ///< ADC value to current offset
extern float adcCla_voltageScale;   ///< ADC value to voltage scale
extern float adcCla_voltageOffset;  ///< ADC value to voltage offset

extern float adcCla_irrResult;                                      ///< adcClaIrrProcessTask() return value - solar irradiance
extern float adcCla_irrInput[ADC_CLA_IRR_IN_DELAY_LINE_LENGTH];     ///< adcClaIrrProcessTask() input values - buffer with last n-samples

extern float adcCla_irrScale;   ///< ADC value to resistance scale
extern float adcCla_irrOffset;  ///< ADC value to resistance offset
extern float adcCla_irrExp;     ///< Resistance to irradiance power
extern float adcCla_irrMult;    ///< Resistance to irradiance scale

/**
 * User defined CLA task functions
 */
__interrupt void adcCla_VAProcessTask();     ///< CLA task 1
__interrupt void adcCla_irrProcessTask();    ///< CLA task 2

#endif /* ADC_CLA_SHARED_H_ */
