/**
 * @file    cla_shared.c
 * @author  Matej Turinsky
 * @date    8. 3. 2024
 * @brief   Source file with CLA-CPU shared resources
 */

#include "DSP28x_Project.h"
#include "cla_shared.h"


#pragma DATA_SECTION(adcCla_VAResult,"Cla1ToCpuMsgRAM")
float adcCla_VAResult[2];

#pragma DATA_SECTION(adcCla_VAInput,"Cla1DataRam0")
float adcCla_VAInput[2][ADC_CLA_VA_IN_DELAY_LINE_LENGTH];

#pragma DATA_SECTION(adcCla_VAOutput,"Cla1DataRam0")
float adcCla_VAOutput[ADC_CLA_VA_OUT_DELAY_LINE_LENGTH];

#pragma DATA_SECTION(adcCla_arcFilterOutputs,"Cla1ToCpuMsgRAM")
float adcCla_arcFilterOutputs[ADC_CLA_NUM_OF_ARC_FILTERS];

#pragma DATA_SECTION(adcCla_arcFilterNumCoefs,"Cla1DataRam0")
float adcCla_arcFilterNumCoefs[ADC_CLA_NUM_OF_ARC_FILTERS][ADC_CLA_LEN_OF_ARC_FILTERS];

#pragma DATA_SECTION(adcCla_arcFilterDenCoefs,"Cla1DataRam0")
float adcCla_arcFilterDenCoefs[ADC_CLA_NUM_OF_ARC_FILTERS][ADC_CLA_LEN_OF_ARC_FILTERS];

#pragma DATA_SECTION(adcCla_currentScale,"Cla1DataRam0")
float adcCla_currentScale;

#pragma DATA_SECTION(adcCla_currentOffset,"Cla1DataRam0")
float adcCla_currentOffset;

#pragma DATA_SECTION(adcCla_voltageScale,"Cla1DataRam0")
float adcCla_voltageScale;

#pragma DATA_SECTION(adcCla_voltageOffset,"Cla1DataRam0")
float adcCla_voltageOffset;

#pragma DATA_SECTION(adcCla_irrResult,"Cla1ToCpuMsgRAM")
float adcCla_irrResult;

#pragma DATA_SECTION(adcCla_irrInput,"Cla1DataRam0")
float adcCla_irrInput[ADC_CLA_IRR_IN_DELAY_LINE_LENGTH];

#pragma DATA_SECTION(adcCla_irrScale,"Cla1DataRam0")
float adcCla_irrScale;

#pragma DATA_SECTION(adcCla_irrOffset,"Cla1DataRam0")
float adcCla_irrOffset;

#pragma DATA_SECTION(adcCla_irrExp,"Cla1DataRam0")
float adcCla_irrExp;

#pragma DATA_SECTION(adcCla_irrMult,"Cla1DataRam0")
float adcCla_irrMult;
