/**
 * @file    wd_tms320f28069.h
 * @author  Matej Turinsky
 * @date    27. 2. 2024
 * @brief   Header file for the TMS320F28069 watchdog driver.
 */

#pragma once

#ifndef WD_TMS320F28069_H_
#define WD_TMS320F28069_H_

#include <stdint.h>
#include "F2806x_Device.h"

/**
 * Watchdog instance definition macro for driver configuration.
 */
#define WD_INSTANCE(_prescaler)         \
        {                               \
            .prescaler = _prescaler     \
        }

/**
 * Watchdog structure for the TMS320F28069.
 */
typedef struct {
    const uint16_t prescaler;
} wd_dev_t;

#endif /* WD_TMS320F28069_H_ */
