/**
 * @file    uart_tms320f28069.h
 * @author  Matej Turinsky
 * @date    27. 2. 2024
 * @brief   Header file for the TMS320F28069 UART driver.
 */

#pragma once

#ifndef UART_TMS320F28069_H_
#define UART_TMS320F28069_H_

#include <stdint.h>
#include "F2806x_Device.h"

/**
 * UART instance definition macro for driver configuration.
 */
#define UART_INSTANCE(_ctrlReg, _rxPort, _rxPin, _txPort, _txPin, _rxBuffer, _rxBufferSize)     \
        {                                                                                       \
            .pCtrlReg = _ctrlReg,                                                               \
            .pRxPort = _rxPort,                                                                 \
            .rxPin = _rxPin,                                                                    \
            .pTxPort = _txPort,                                                                 \
            .txPin = _txPin,                                                                    \
            .pRxBuffer = _rxBuffer,                                                             \
            .rxBufferSize = _rxBufferSize                                                       \
        }

/**
 * UART structure for the TMS320F28069.
 */
typedef struct SCI_REGS* const pUartCtrlReg_t;
typedef struct GPIO_CTRL_REGS* const pUartPortCtrlReg_t;

typedef struct {
    pUartCtrlReg_t pCtrlReg;

    char* const pRxBuffer;
    const size_t rxBufferSize;
    size_t rxBufferHead;
    size_t rxBufferTail;

    pUartPortCtrlReg_t pRxPort;
    const uint16_t rxPin;
    pUartPortCtrlReg_t pTxPort;
    const uint16_t txPin;
} uart_dev_t;

/**
 * UART register to pointer casting macros (use these in 'conf_driver.h')
 */
#define UART_CTRL_REG_CAST(reg)     (pUartCtrlReg_t)(void*)(&reg)
#define UART_RX_PORT_REG_CAST(reg)  (pUartPortCtrlReg_t)(void*)(&reg)
#define UART_TX_PORT_REG_CAST(reg)  (pUartPortCtrlReg_t)(void*)(&reg)

#endif /* UART_TMS320F28069_H_ */
