/**
 * @file    pool.c
 * @author  Roman Mego
 * @date    21. 2. 2024
 * @brief   MT-PLC-SEMx PLC memory pool.
 */

#include <stddef.h>

#include <lwip/ip6.h>
#include <lwip/pbuf.h>

LWIP_MEMPOOL_DECLARE(plc_pool_rx, 1, sizeof(struct pbuf_custom) + IP6_MIN_MTU_LENGTH, "PLC Rx pool.");

struct pbuf_rx
{
    struct pbuf_custom pbuf;
    uint8_t buff[IP6_MIN_MTU_LENGTH];
};

typedef struct pbuf_rx pbuf_rx_t;

void plc_pool_init(void)
{
    LWIP_MEMPOOL_INIT(plc_pool_rx);
}

void plc_pbuf_rx_free(struct pbuf* p)
{
    struct pbuf_custom* pbuf = (struct pbuf_custom*)p;
    LWIP_MEMPOOL_FREE(plc_pool_rx, pbuf);
}

struct pbuf* plc_pool_rx_pbuf_alloc(void)
{
    struct pbuf* pbuf;
    struct pbuf_custom* p = LWIP_MEMPOOL_ALLOC(plc_pool_rx);

    if (p == NULL)
    {
        pbuf = NULL;
    }
    else
    {
        void* buff = ((uint8_t*)p) + offsetof(pbuf_rx_t, buff);
        p->custom_free_function = plc_pbuf_rx_free;
        pbuf = pbuf_alloced_custom(PBUF_RAW, IP6_MIN_MTU_LENGTH, PBUF_POOL, p, buff, IP6_MIN_MTU_LENGTH);
    }

    return ((struct pbuf*)p);
}
