/**
 * @file    apps/transfer.h
 * @author  Roman Mego, Matej Turinsky
 * @date    2. 2. 2024
 * @brief   Data transfer.
 */

#pragma once

#ifndef APPS_TRANSFER_H_
#define APPS_TRANSFER_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <stddef.h>
#include <lwip/err.h>
#include <lwip/ip_addr.h>

typedef void (*transfer_receive_call_t)(void*, const ip_addr_t* addr, const void*, size_t);

err_t transfer_init(transfer_receive_call_t receive, void* arg);

err_t transfer_start(void);

err_t transfer_stop(void);

err_t transfer_send(const ip_addr_t* addr, const void* data, size_t bytes);

#if defined(__cplusplus)
}
#endif

#endif /* APPS_TRANSFER_H_ */
