/**
 * @file    modemtec/plc-core/pool.h
 * @author  Roman Mego
 * @date    22. 1. 2024
 * @brief   MT-PLC-SEMx PLC memory pool for lwIP definitions.
 */

#pragma once

#ifndef MODEMTEC_PLC_CORE_POOL_H_
#define MODEMTEC_PLC_CORE_POOL_H_

#ifndef MODEMTEC_PLC_CORE_PLC_H_
#   error "Do not include <modemtec/plc-core/pool.h> directly in application."
#endif

#include <lwip/pbuf.h>

/**
 * @brief   Initialize memory pools for PLC core in lwIP.
 */
void plc_pool_init(void);

/**
 * @brief   Allocate packet buffer from PLC reception pool.
 * @return  Pointer to allocated packet buffer.
 */
struct pbuf* plc_pool_rx_pbuf_alloc(void);

#endif /* MODEMTEC_PLC_CORE_POOL_H_ */
