/**
 * @file    core-mt-plc-sem2-config.h
 * @author  Matej Turinsky
 * @date    12. 1. 2024
 * @brief   Driver configuration file for STM32F415xx variant of MT-PLC-SEM2
 */

#pragma once

#ifndef CORE_MT_PLC_SEM2_CONFIG_H_
#define CORE_MT_PLC_SEM2_CONFIG_H_

#define USE_WD_DRIVER                       1
#define USE_RANDOM_DRIVER                   1
#define USE_RTC_DRIVER                      1
#define USE_GPIO_DRIVER                     1
#define USE_UART_DRIVER                     1
#   define UART_DEFAULT_BAUDRATE            115200
#   define UART1_BUFFER_SIZE                2048
#   define UART2_BUFFER_SIZE                8192
#   define UART3_BUFFER_SIZE                128
#define USE_I2C_DRIVER                      1
#define USE_SPI_DRIVER                      1
#define USE_ADC_DMA_DRIVER                  1
#define USE_DMA_DRIVER                      1
#   define DISABLE_DMA1_STREAM_0            1
#   define DISABLE_DMA1_STREAM_1            1
#   define DISABLE_DMA1_STREAM_2            1
#   define DISABLE_DMA1_STREAM_3            1
#   define DISABLE_DMA1_STREAM_4            1
#   define DISABLE_DMA1_STREAM_5            1
#   define DISABLE_DMA1_STREAM_6            1
#   define DISABLE_DMA1_STREAM_7            1
#   define DISABLE_DMA2_STREAM_1            1
#   define DISABLE_DMA2_STREAM_2            1
#   define DISABLE_DMA2_STREAM_3            1
#   define DISABLE_DMA2_STREAM_4            1
#   define DISABLE_DMA2_STREAM_5            1
#   define DISABLE_DMA2_STREAM_6            1
#   define DISABLE_DMA2_STREAM_7            1
#define USE_TIM_DRIVER                      1
#   define DISABLE_TIM2                     1
#   define DISABLE_TIM3                     1
#   define DISABLE_TIM4                     1
#   define DISABLE_TIM6                     1
#   define DISABLE_TIM7                     1
#   define DISABLE_TIM9                     1
#   define DISABLE_TIM10                    1
#   define DISABLE_TIM11                    1
#   define DISABLE_TIM12                    1
#   define DISABLE_TIM13                    1
#   define DISABLE_TIM14                    1
#define USE_I2CMEM_DRIVER                   1
#define USE_AT25SF_DRIVER                   1
#define USE_SM2400G3_DRIVER                 1
#   define SM2400G3_TASKS_MAX_PRIORITY      (configMAX_PRIORITIES - 1)
#   define SM2400G3_COORDINATOR_SUPPORT     1
#   define SM2400G3_RANDOM_DEVICE           "/dev/random"
#   define SM2400G3_DATABUFFER_SIZE         UART2_BUFFER_SIZE
#define USE_SM2400G3PHY_DRIVER              1
#define USE_SM2400LOADER_DRIVER             1

#define CORE_AVAILABLE_DEVICES                                                      \
    DEVICE("/dev/wdog0",  wd,       0),      /* Internal watchdog               */  \
    DEVICE("/dev/rtc",    rtc,      0),      /* RTC and backup memory           */  \
    DEVICE("/dev/random", random,   0),      /* Random number generator         */  \
    DEVICE("/dev/io0",    gpio,     0),      /* SM2400 HOST REQ + RESET + BOOT  */  \
    DEVICE("/dev/io1",    gpio,     1),      /* Status LED              */  \
    DEVICE("/dev/gpio0",  gpio,     2),      /* GPIOB for application   */  \
    DEVICE("/dev/gpio1",  gpio,     3),      /* GPIOC for application   */  \
    DEVICE("/dev/uart0",  uart,     0),      /* Primary UART            */  \
    DEVICE("/dev/uart1",  uart,     1),      /* Service UART            */  \
    DEVICE("/dev/uart2",  uart,     2),      /* SM2400 UART             */  \
    DEVICE("/dev/spi0",   spi,      0),      /* SPI3 for application    */  \
    DEVICE("/dev/spi1",   spi,      1),      /* SM2400 SPI              */  \
    DEVICE("/dev/spi2",   spi,      2),      /* Flash SPI               */  \
    DEVICE("/dev/i2c0",   i2c,      0),      /* I2C                     */  \
    DEVICE("/dev/dma0",   dma,      0),      /* DMA controller          */  \
    DEVICE("/dev/tim0",   tim,      0),      /* General-purpose timer   */  \
    DEVICE("/dev/adc0",   adc_dma,  0),      /* A/D converter           */  \
    DEVICE("/dev/mtd0",   at25sf,   0),      /* Flash memory            */  \
    DEVICE("/dev/mtd1",   i2cmem,   0),      /* EEPROM                  */  \
    DEVICE("/dev/plc0-asl",    sm2400g3, 0),    /* SM2400 PLC modem     */  \
    DEVICE("/dev/plc0-phy",    sm2400g3phy, 0), /* SM2400 PLC modem     */  \
    DEVICE("/dev/plc0-loader", sm2400loader, 0) /* SM2400 loader        */

#define AVAILABLE_WD_DEVICES        \
    WD_INSTANCE(0x07, 0x0FFFF)

#define AVAILABLE_RTC_DEVICES       \
    RTC_INSTANCE()

#define AVAILABLE_RANDOM_DEVICES    \
    RANDOM_INSTANCE()

#define AVAILABLE_GPIO_DEVICES                                                                      \
    GPIO_INSTANCE(GPIOB, (1 << 3) | (1 << 4) | (1 << 5)),   /* SM2400 RESET = PB3, HOSTREQ = PB4, BOOT = PB5    */  \
    GPIO_INSTANCE(GPIOC, (1 << 8) | (1 << 9)),              /* Status LED                                       */  \
    GPIO_INSTANCE(GPIOB, (1 << 0) | (1 << 1)),              /* GPIOB                                            */  \
    GPIO_INSTANCE(GPIOC, (1 << 1) | (1 << 2) | (1 << 3) | (1 << 4) | (1 << 5))  /* GPIOC                        */

#define AVAILABLE_UART_DEVICES                                                                                                          \
    UART_INSTANCE(USART2, GPIOA,  3, GPIOA,  2, GPIOA, 1, GPIOA, 0, GPIOD, 2, buffer_uart2, UART2_BUFFER_SIZE), /* Primary UART     */  \
    UART_INSTANCE(USART3, GPIOB, 11, GPIOB, 10, NULL, 0, NULL, 0, NULL, 0, buffer_uart3, UART3_BUFFER_SIZE),    /* Service UART     */  \
    UART_INSTANCE(USART1, GPIOA, 10, GPIOA,  9, NULL, 0, NULL, 0, NULL, 0, buffer_uart1, UART1_BUFFER_SIZE)     /* SM2400 UART      */

#define AVAILABLE_I2C_DEVICES                                               \
    I2C_INSTANCE(I2C1, 400000, GPIOB, 7, GPIOB, 6)  /* External I2C */

#define AVAILABLE_SPI_DEVICES  \
    SPI_INSTANCE(SPI3, STM32_SPI_MODE_0, 1000000, GPIOC, 11, GPIOC, 12, GPIOC, 10, GPIOA, (1 << 15)),   /* Generic SPI  */  \
    SPI_INSTANCE(SPI2, STM32_SPI_MODE_0, 50000000, GPIOB, 14, GPIOB, 15, GPIOB, 13, GPIOB, (1 << 12)),  /* Flash SPI    */  \
    SPI_INSTANCE(SPI1, STM32_SPI_MODE_3, 1000000, GPIOA,  6, GPIOA,  7, GPIOA,  5, GPIOA, (1 << 4))     /* SM2400 SPI   */

#define AVAILABLE_ADC_DMA_DEVICES                                                                                               \
    ADC_DMA_INSTANCE(ADC1, 1 << 10, "/dev/dma0", "/dev/tim0", 0, LL_ADC_REG_TRIG_EXT_TIM5_CH1)  /* ADC for spectrum measurement */

#define AVAILABLE_DMA_DEVICES                                               \
    DMA_INSTANCE(DMA2, LL_DMA_STREAM_0, LL_DMA_CHANNEL_0, LL_DMA_MODE_NORMAL | LL_DMA_PRIORITY_LOW)     /* DMA for ADC data transfer */

#define AVAILABLE_TIM_DEVICES                                               \
    TIM_INSTANCE(TIM5, LL_TIM_TRGO_OC1REF, NULL, 0, NULL, 0, NULL, 0, NULL, 0)

#define AVAILABLE_I2CMEM_DEVICES                                            \
    I2CMEM_GENERAL_INSTANCE("/dev/i2c0", 0x50, 256, 16, 1)  /* 24AA025E64 */

#define AVAILABLE_AT25SF_DEVICES                                            \
    AT25DF081_INSTANCE("/dev/spi1", 12)

#define AVAILABLE_SM2400G3_DEVICES                                          \
    SM2400G3_INSTANCE("/dev/uart2", NULL, "/dev/rtc", 0, 0, 0)

#define AVAILABLE_SM2400G3PHY_DEVICES                                       \
    SM2400G3PHY_INSTANCE("/dev/uart2", NULL, 0, 0, 0, 0)

#define AVAILABLE_SM2400LOADER_DEVICES                                      \
    SM2400LOADER_INSTANCE("/dev/uart2", "/dev/io0", (1 << 3), 0, (1 << 5), 0)

#endif /* CORE_MT_PLC_SEM2_CONFIG_H_ */
