/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32wlxx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/*Vycet typu jednotek*/
enum UniteType{
	MasterUnit = 0,
	SlaveUnit = 1
};

/*Vycet rozpyloveho faktoru SF5-12*/
enum {
	SF5 = 5,	// rozptylovy faktor 5
	SF6 = 6,	// rozptylovy faktor 6
	SF7 = 7,	// rozptylovy faktor 7
	SF8 = 8,	// rozptylovy faktor 8
	SF9 = 9,	// rozptylovy faktor 9
	SF10 = 10,	// rozptylovy faktor 11
	SF11 = 11,	// rozptylovy faktor 11
	SF12 = 12	// rozptylovy faktor 12
};

/*Vycet sirky pasma*/
enum {
	BW125 = 0,	// 125 kHz
	BW250 = 1,	// 250 kHz
	BW500 = 2	// 500 kHz
};

/*Vycet kodovaciho pomeru*/
enum {
	CR4_5 = 1,	// kodovaci pomer 4/5
	CR4_6 = 2,	// kodovaci pomer 4/6
	CR4_7 = 3,	// kodovaci pomer 4/7
	CR4_8 = 4	// kodovaci pomer 4/8
};

/*Vycet zapnuti/vypnuti CRC u LoRa zprav*/
enum {
	CRCon = 1,	// CRC zapnute
	CRCoff = 0	// CRC vypnute
};

/*Vycet normalni nebo invertovane CHIRP signaly*/
enum {
	IQ_NORMAL = 0,  //roustouci CHIRP
	IQ_INVERT = 1	//klesajici CHIRP
};

/*Vycet nastaveni implicitni nebo explicitni hlavicky LoRa zprav*/
enum {
	NO_FIX_PAYLOAD_LEN = 0,		// explicitni hlavicka
	FIX_PAYLOAD_LEN =1			// implicitni hlavicka
};

/*Vycet nastaveni vysilaciho vykonu LoRa*/
enum {
	TX_PRW14_dbm = 14,		// vysilaci vykon 14 dBm
	TX_RPW_20_dbm = 20		// vysilaci vykon 20 dBm
};

/*Vycet nastaveni delky preambule LoRa zpravy (v symbolech)*/
enum {
	PREAM_LEN8 = 8,		// 8 symbolu
	PREAM_LEN9 = 9,		// 9 symbolu
	PREAM_LEN10 = 10,	// 10 symbolu
	PREAM_LEN11 = 11,	// 11 symbolu
	PREAM_LEN12 = 12	// 12 symbolu
};

/*Vycet nastaveni po jake dobe (v symbolech) je ukonceno nacitani zprvavy LoRa kdyz nepride dalsi symbol */
enum {
	SYMBOL_TIMEOUT5 = 5,	// 5 symbolu
	SYMBOL_TIMEOUT6 = 6,	// 6 symbolu
	SYMBOL_TIMEOUT7 = 7,	// 7 symbolu
	SYMBOL_TIMEOUT8 = 8,	// 8 symbolu
	SYMBOL_TIMEOUT9 = 9,	// 9 symbolu
	SYMBOL_TIMEOUT10 = 10,	// 10 symbolu
	SYMBOL_TIMEOUT11 = 11,	// 11 symbolu
	SYMBOL_TIMEOUT12 = 12	// 12 symbolu
};


/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */
extern RTC_HandleTypeDef hrtc;
/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);
void MX_SUBGHZ_Init(void);

/* USER CODE BEGIN EFP */
void MX_RTC_Init(void);
/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define RTC_PREDIV_A ((1<<(15-RTC_N_PREDIV_S))-1)
#define RTC_N_PREDIV_S 10
#define RTC_PREDIV_S ((1<<RTC_N_PREDIV_S)-1)
#define LED1_Pin GPIO_PIN_15
#define LED1_GPIO_Port GPIOB
#define SPI2_CS_Pin GPIO_PIN_4
#define SPI2_CS_GPIO_Port GPIOB
#define LED2_Pin GPIO_PIN_9
#define LED2_GPIO_Port GPIOB
#define FE_CTRL3_Pin GPIO_PIN_3
#define FE_CTRL3_GPIO_Port GPIOC
#define B1_Pin GPIO_PIN_0
#define B1_GPIO_Port GPIOA
#define FE_CTRL2_Pin GPIO_PIN_5
#define FE_CTRL2_GPIO_Port GPIOC
#define FE_CTRL1_Pin GPIO_PIN_4
#define FE_CTRL1_GPIO_Port GPIOC
#define B3_Pin GPIO_PIN_6
#define B3_GPIO_Port GPIOC
#define B2_Pin GPIO_PIN_1
#define B2_GPIO_Port GPIOA
#define LED3_Pin GPIO_PIN_11
#define LED3_GPIO_Port GPIOB
#define T_VCP_RX_Pin GPIO_PIN_3
#define T_VCP_RX_GPIO_Port GPIOA
#define T_VCP_RXA2_Pin GPIO_PIN_2
#define T_VCP_RXA2_GPIO_Port GPIOA

/* USER CODE BEGIN Private defines */
#define FlashFirstAdress 0x0803FFF8			//prvni adresa pro zapis na FLASH
#define SD_SPI_HANDLE hspi2
/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
