from flask import jsonify, Flask, request
from flask_cors import CORS, cross_origin
from db import DataBase

app = Flask(__name__)
CORS(app, support_credentials = True)

tables = ["picking", "real_data"]


@app.route("/")
@cross_origin(supports_credentials = True)
def main():
    return "<p>Server is running</p>"


# Get all data from table
@app.get("/<table_name>/get-all")
@cross_origin(supports_credentials = True)
def getAll(table_name):
    db = DataBase()

    if not (table_name in tables):
        return "Table doesn't exist", 404

    data = None
    if table_name == "real_data":
        data = db.get_all_real_data()
    else:
        data = db.get_all(table_name)

    return jsonify(data)

@app.get("/real_data/products")
@cross_origin(supports_credentials = True)
def countProducts():
    db = DataBase()

    row = db.get_all_real_data()

    data = []

    for real_data in row:
        
        # Append product to list if it isn't there
        if not any(d["product"] == real_data["product"] for d in data):
            data.append({"product": real_data["product"]})

    return jsonify(data)


@app.get("/real_data/prod/<attribute>")
@cross_origin(supports_credentials = True)
def countProductAttributes(attribute):
    db = DataBase()

    row = db.get_all_real_data()

    data = []

    for real_data in row:
        # Append product to list if it isn't there
        if not any(d["product"] == real_data["product"] for d in data):
            data.append({"product": real_data["product"]})

        for element in data:
            if element["product"] == real_data["product"]:

                # Result is int, so we need to process it in a different way
                if attribute == "result":
                    if real_data[attribute]:
                        try:
                            element["~OK"] += 1
                        except KeyError:
                            element["~OK"] = 1
                    else:
                        try:
                            element["~NOK"] += 1
                        except KeyError:
                            element["~NOK"] = 1
                    continue

                try:
                    element[real_data[attribute]] += 1
                except KeyError:
                    element[real_data[attribute]] = 1


    return jsonify(data)

@app.get("/real_data/bullet/<attribute>")
@cross_origin(supports_credentials = True)
def countBulletAttributes(attribute):
    db = DataBase()

    row = db.get_all_real_data()

    data = [{"id": "result",
             "ranges": [0, 0],
             "measures": 0,
             "markers": [0]}]

    return jsonify(data)

@app.get("/real_data/<attribute>/count")
@cross_origin(supports_credentials = True)
def countRealDataAttributes(attribute):
    db = DataBase()

    row = db.get_all_real_data()

    data = []
    if attribute == "defects":
        for real_data in row:
            if not any(d["label"] == real_data["defect"] for d in data):
                data.append({
                    "label": real_data["defect"],
                    "id": real_data["defect"],
                    "value": 0,
                })

            for element in data:
                if element["label"] == real_data["defect"]:
                    element["value"] += 1

    elif attribute == "batch_number":
        for real_data in row:
            if not any(d["label"] == real_data["batch_number"] for d in data):
                data.append({
                    "label": real_data["batch_number"],
                    "id": real_data["batch_number"],
                    "value": 0,
                })

            for element in data:
                if element["label"] == real_data["batch_number"]:
                    element["value"] += 1

    elif attribute == "product":
        for real_data in row:
            if not any(d["label"] == real_data["product"] for d in data):
                data.append({
                    "label": real_data["product"],
                    "id": real_data["product"],
                    "value": 0,
                })

            for element in data:
                if element["label"] == real_data["product"]:
                    element["value"] += 1

    for element in data:
        if element["label"] is None:
            element["label"] = "OK"
            element["id"] = "OK"

    return jsonify(data)

@app.get("/picking/ground_truth_result/count")
@cross_origin(supports_credentials = True)
def countPickingGroundTruthResults():
    db = DataBase()

    row = db.get_all("picking")

    data = [{"id": "0", "label": "0", "value": 0},
            {"id": "25", "label": "25", "value": 0},
            {"id": "50", "label": "50", "value": 0},
            {"id": "75", "label": "75", "value": 0},
            {"id": "100", "label": "100", "value": 0}]
    for picking in row:
        for element in data:
            if str(picking["ground_truth_result"]) == element["label"]:
                element["value"] += 1


    return jsonify(data)

@app.get("/picking/result")
@cross_origin(supports_credentials = True)
def countPickingResult():
    db = DataBase()

    row = db.get_all("picking")

    data = [{"label": "result1", "id": "result1", "OK": 0, "NOK": 0},
            {"label": "result2", "id": "result2", "OK": 0, "NOK": 0},
            {"label": "result3", "id": "result3", "OK": 0, "NOK": 0},
            {"label": "result4", "id": "result4", "OK": 0, "NOK": 0}]
    for picking in row:
        for element in data:
            if (picking["result_1"]) == 1:
                element["OK"] += 1
            else:
                element["NOK"] += 1

    return jsonify(data)

@app.get("/picking/detail_id/<attribute>")
@cross_origin(supports_credentials = True)
def countPickingAttributes(attribute):
    db = DataBase()

    row = db.get_all("picking")

    data = []

    for picking in row:
        # Append product to list if it isn't there
        if not any(d["detail_id"] == picking["detail_id"] for d in data):
            data.append({"detail_id": picking["detail_id"]})

        for element in data:
            if element["detail_id"] == picking["detail_id"]:

                # Result is int, so we need to process it in a different way
                if attribute == "repeatability":
                    if picking[attribute]:
                        try:
                            element["~OK"] += 1
                        except KeyError:
                            element["~OK"] = 1
                    else:
                        try:
                            element["~NOK"] += 1
                        except KeyError:
                            element["~NOK"] = 1
                    continue

                if attribute == "ground_truth_result":
                    try:
                        element["0"] += 1
                    except KeyError:
                        element["0"] = 1

                if attribute != "ground_truth_result":
                    try:
                        element[picking[attribute]] += 1
                    except KeyError:
                        element[picking[attribute]] = 1

    return jsonify(data)


@app.get("/bar/defects/")
@cross_origin(supports_credentials = True)
def barDefects():
    db = DataBase()

    row = db.get_defects_with_products()

    data = []

    for defect_product in row:
        if not any(d["defect"] == defect_product["defect_name"] for d in data):
            data.append({"defect": defect_product["defect_name"]})

        for element in data:
            if element["defect"] == defect_product["defect_name"]:
                if not defect_product["product_name"] in element.keys():
                    element[defect_product["product_name"]] = 0

                element[defect_product["product_name"]] += 1


    return jsonify(data)


@app.get("/bullet/result/")
@cross_origin(supports_credentials = True)
def bulletResult():
    db = DataBase()

    row = db.get_all("picking")
    print(row)

    ground_truth_counter = len([d for d in row if d["ground_truth"]])
    res = [{
        "id": "result",
        "ranges": [0, ground_truth_counter, len(row)],
        "measures": [len(row) - ground_truth_counter],
        "markers": [len(row) * 0.1],
    }]



    return jsonify(res)


@app.get("/bullet/repeatability/")
@cross_origin(supports_credentials = True)
def bulletRepeatability():
    db = DataBase()

    row = db.get_all("picking")
    print(row)

    repeatability_counter = len([d for d in row if d["repeatability"]])
    res = [{
        "id": "repeatability",
        "ranges": [0, repeatability_counter, len(row)],
        "measures": [len(row) - repeatability_counter],
        "markers": [len(row) * 0.1],
    }]



    return jsonify(res)


@app.get("/bar/ground_truth_result/")
@cross_origin(supports_credentials = True)
def barGroundTruth():
    db = DataBase()

    row = db.get_all("picking")

    data = [{"ground_truth0": 0},
            {"ground_truth25": 0},
            {"ground_truth50": 0},
            {"ground_truth75": 0},
            {"ground_truth100": 0}]
    for picking in row:
        for element in data:
            key = "ground_truth" + str(picking["ground_truth_result"])
            if key in element.keys():
                element[key] += 1


    return jsonify(data)

# RIP
@app.get("/line/defects/")
@cross_origin(supports_credentials = True)
def lineDefects():
    db = DataBase()

    row = db.get_defects_with_products()

    data = []

    for defect_product in row:
        if not any(d["id"] == defect_product["product_name"] for d in data):
            data.append({"id": defect_product["product_name"], "data": []})

        for element in data:
            if defect_product["product_name"] == element["id"]:
                if not any(d["x"] == defect_product["defect_name"] for d in element["data"]):
                    element["data"].append({"x": defect_product["defect_name"], "y": 0})

                for d in element["data"]:
                    if d["x"] == defect_product["defect_name"]:
                        d["y"] += 1

    return jsonify(data)