import { Box, Typography, useTheme } from "@mui/material";
import { DataGrid, GridColumns } from '@mui/x-data-grid'
import { tokens } from "../../../theme";
import { useEffect, useState } from "react";
import axios from "axios";

interface Row {
    row: {
        result: boolean
        defect: Array<string>
    }
}

const RealDataTable = () => {
    const theme = useTheme()
    const colors = tokens(theme.palette.mode)

    const [realData, setRealData] = useState<Object[]>([])

    useEffect(() => {
      axios.get("http://127.0.0.1:5000/real_data/get-all")
        .then((response) => {
          if (response.status !== 200) throw ("Something went wrong");

          setRealData(response.data)
        })
        .catch((err) => console.log(err));
    }, [])

    const columns: GridColumns = [
        { field: 'id', headerName: 'ID', headerAlign: 'center', align: 'center'},
        { field: 'serial_number', headerName: 'Serial Number', flex: 1, headerAlign: 'center', align: 'center'},
        { field: 'batch_number', headerName: 'Batch Number', flex: 1, headerAlign: 'center', align: 'center'},
        { field: 'timestamp', headerName: 'Timestamp', flex: 1, headerAlign: 'center', align: 'center'},
        { field: 'product', headerName: 'Product', flex: 1, headerAlign: 'center', align: 'center'},
        { field: 'result', headerName: 'Result', flex: 1, headerAlign: 'center',
            renderCell: ({ row: { result }} : Row) => {
                return (
                <Box
                    width='50%'
                    p='3px'
                    m='0 auto'
                    display='flex'
                    justifyContent='center'
                    border='2px solid'
                    borderColor={
                        result ? colors.greenAccent[400] : colors.redAccent[500]
                    }
                    borderRadius='4px'
                >
                    <Typography color={result ? colors.greenAccent[400] : colors.redAccent[500]} >
                    { result ? 'OK' : 'NOK' }
                    </Typography>
                </Box>
                )
            }
        },
        { field: 'defect', headerName: 'defect', flex: 1, headerAlign: 'center',
            renderCell: ({ row: { defect }} : Row) => {
                return (
                    <Box
                    p='3px'
                    m='0 auto'
                    display='flex'
                    justifyContent='center'
                >
                    { [defect].map((defect) => (<p>{defect}</p>)) }
                </Box>
                )
            }
        },
    ]

    return (
        <Box m='20px'>
            <Box
                m='20px 0'
                height='75vh'
                sx={{
                    "& .MuiDataGrid-root": {
                      border: "none",
                    },
                    "& .MuiDataGrid-cell:hover": {
                      color: colors.grey[100]
                    },
                    "& .MuiDataGrid-columnHeaders": {
                      backgroundColor: colors.blueAccent[500],
                      borderBottom: "none",
                    },
                    "& .MuiDataGrid-virtualScroller": {
                      backgroundColor: colors.primary[400],
                    },
                    "& .MuiDataGrid-footerContainer": {
                      borderTop: "none",
                      backgroundColor: colors.blueAccent[500],
                    },
                    "& .MuiCheckbox-root": {
                      color: `${colors.greenAccent[200]} !important`,
                    }
                }}
            >
                <DataGrid
                  rows={realData}
                  columns={columns}
                  disableColumnSelector={true}
                  loading={realData.length === 0}
                  sx={{
                    boxShadow: 2,
                    border: 2
                  }}
                />
            </Box>
        </Box>
    )
}

export default RealDataTable