// import Header from "../../../components/Header";
import { DataGrid, GridColumns } from '@mui/x-data-grid'
import { tokens } from "../../../theme";
import { Box, Typography, useTheme } from "@mui/material";
import { useEffect, useState } from 'react';
import axios from 'axios'

interface BooleanRow {
  row: {
      ground_truth?: boolean
      result_1?: boolean
      result_2?: boolean
      result_3?: boolean
      result_4?: boolean
      repeatability?: boolean
  }
}

const Picking = () => {

    const [products, setProducts] = useState<Object[]>([])

    useEffect(() => {
      axios.get("http://127.0.0.1:5000/picking/get-all")
        .then((response) => {
          if (response.status !== 200) throw ("Something went wrong");

          setProducts(response.data)
        })
        .catch((err) => console.log(err));
    }, [])

    const theme = useTheme()
    const colors = tokens(theme.palette.mode)

    const columns: GridColumns = [
        { field: 'id', headerName: 'ID', headerAlign: 'center', align: 'center'},
        { field: 'serial_number', headerName: 'Serial Number', flex: 1, headerAlign: 'center', align: 'center'},
        { field: 'ground_truth', headerName: 'Ground Truth', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { ground_truth }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                border='2px solid'
                borderColor={
                  ground_truth ? colors.greenAccent[400] : colors.redAccent[500]
                }
                borderRadius='4px'
              >
                <Typography color={ground_truth ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { ground_truth ? 'OK' : 'NOK' }
                </Typography>
              </Box>
            )
          }  
        },
        { field: 'detail_id', headerName: 'Detail ID', flex: 1, headerAlign: 'center', align: 'center' },
        { field: 'result_1', headerName: 'Result 1', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { result_1 }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                border='2px solid'
                borderColor={
                    result_1 ? colors.greenAccent[400] : colors.redAccent[500]
                }
                borderRadius='4px'
              >
                <Typography color={result_1 ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { result_1 ? 'PASS' : 'FAIL' }
                </Typography>
              </Box>
            )
          }  
        },
        { field: 'result_2', headerName: 'Result 2', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { result_2 }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                border='2px solid'
                borderColor={
                    result_2 ? colors.greenAccent[400] : colors.redAccent[500]
                }
                borderRadius='4px'
              >
                <Typography color={result_2 ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { result_2 ? 'PASS' : 'FAIL' }
                </Typography>
              </Box>
            )
          }
        },
        { field: 'result_3', headerName: 'Result 3', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { result_3 }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                border='2px solid'
                borderColor={
                    result_3 ? colors.greenAccent[400] : colors.redAccent[500]
                }
                borderRadius='4px'
              >
                <Typography color={result_3 ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { result_3 ? 'PASS' : 'FAIL' }
                </Typography>
              </Box>
            )
          }
        },
        { field: 'result_4', headerName: 'Result 4', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { result_4 }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                border='2px solid'
                borderColor={result_4 ? colors.greenAccent[400] : colors.redAccent[500]}
                borderRadius='4px'
              >
                <Typography color={result_4 ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { result_4 ? 'PASS' : 'FAIL' }
                </Typography>
              </Box>
            )
          }
        },
        { field: 'repeatebility', headerName: 'Repeatebility', flex: 1, headerAlign: 'center',
          renderCell: ({ row: { repeatability }} : BooleanRow) => {
            return (
              <Box 
                width='50%'
                p='3px'
                m='0 auto' 
                display='flex'
                justifyContent='center'
                borderRadius='4px'
              >
                <Typography color={repeatability ? colors.greenAccent[400] : colors.redAccent[500]} >
                  { repeatability ? 'True' : 'False' }
                </Typography>
              </Box>
            )
          }
        },
        { field: 'ground_truth_result', headerName: 'Ground Truth Result', flex: 2, headerAlign: 'center', align: 'center' }
    ]
    return (
        <Box m='20px'>
            <Box 
                m='20px 0'
                height='75vh'
                sx={{
                    "& .MuiDataGrid-root": {
                      border: "none",
                    },
                    "& .MuiDataGrid-cell:hover": {
                      color: colors.grey[100]
                    },
                    "& .MuiDataGrid-columnHeaders": {
                      backgroundColor: colors.blueAccent[500],
                      borderBottom: "none",
                    },
                    "& .MuiDataGrid-virtualScroller": {
                      backgroundColor: colors.primary[400],
                    },
                    "& .MuiDataGrid-footerContainer": {
                      borderTop: "none",
                      backgroundColor: colors.blueAccent[500],
                    },
                    "& .MuiCheckbox-root": {
                      color: `${colors.greenAccent[200]} !important`,
                    }
                }}
            >
                <DataGrid 
                  rows={products}
                  columns={columns}
                  disableColumnSelector={true}
                  loading={products.length === 0}
                  sx={{
                    boxShadow: 2,
                    border: 2
                  }}
                />
            </Box>
        </Box>
    )
}

export default Picking