import { Box, useTheme, Typography, Button } from "@mui/material";
import Header from "../../../components/Header";
import { tokens } from "../../../theme";
import { NonLinearSlider } from "../../../components/NonLinearSlider";
import { useState, useContext } from "react";
import Selector from "../../../components/Selector";
import ColorInput from "../../../components/ColorInput";
import { SettingBlock } from "../../../components/SettingBlock";
import { IPIE_PROPS } from "../../../constants/graphProps";
import Graph from "../../../components/Graph";
import { ModalContext } from '../../../context/ModalContext';

const Pie = ({
  graph,
  onChangeGraphProps,
  graphProps,
}
:
{
  graph?: any,
  onChangeGraphProps?: (newProps: IPIE_PROPS) => null,
  graphProps?: IPIE_PROPS,
}
) => {

  const theme = useTheme()
  const colors = tokens(theme.palette.mode)
  const {close: closeModal} = useContext(ModalContext)

  const [innerRadius, setInnerRadius] = useState(graphProps?.innerRadius || 0)
  const [startAngle, setStartAngle] = useState(graphProps?.startAngle || 0)
  const [endAngle, setEndAngle] = useState(graphProps?.endAngle || 360)
  const [padAngle, setPadAngle] = useState(graphProps?.padAngle || 0)
  const [cornerRadius, setCornerRadius] = useState(graphProps?.cornerRadius || 0)
  const [schem, setSchem] = useState(graphProps?.schem || "nivo")
  const [borderWidth, setBorderWidth] = useState(graphProps?.borderWidth || 0)
  const [borderCol, setBorderCol] = useState(graphProps?.borderColor || "rgb(0, 0, 0)")
  const [enableArcLabels, setEnableArcLabels] = useState(graphProps?.enableArcLabels || true)
  const [enableArcLinkLabels, setEnableArcLinkLabels] = useState(graphProps?.enableArcLinkLabels || false)
  const [isInteractive, setIsInteractive] = useState(graphProps?.isInteractive || true)
  const [isAnimate, setIsAnimate] = useState(graphProps?.animate || true)
  const [arcLabelsRadiusOffset, setArcLabelsRadiusOffset] = useState(graphProps?.arcLabelsRadiusOffset || 0.5)
  const [arcLabelsSkipAngle, setArcLabelsSkipAngle] = useState(graphProps?.arcLabelsSkipAngle || 0)
  const [labelsCol, setLabelsCol] = useState(graphProps?.arcLabelsTextColor || "rgb(0, 0, 0)")
  const [arcLinkLabelsSkipAngle, setArcLinkLabelsSkipAngle] = useState(graphProps?.arcLinkLabelsSkipAngle || 0)
  const [arcLinkLabelsDiagonalLength, setArcLinkLabelsDiagonalLength] = useState(graphProps?.arcLinkLabelsDiagonalLength || 16)
  const [arcLinkLabelsStraightLength, setArcLinkLabelsStraightLength] = useState(graphProps?.arcLinkLabelsStraightLength || 24)
  const [arcLinkLabelsTextOffset, setArcLinkLabelsTextOffset] = useState(graphProps?.arcLinkLabelsTextOffset || 6)
  const [arcLinkLabelsThickness, setArcLinkLabelsThickness] = useState(graphProps?.arcLinkLabelsThickness || 1)
  const [arcLinkLabelsTextColor, setArcLinkLabelsTextColor] = useState(graphProps?.arcLinkLabelsTextColor || "rgb(0, 0, 0)")
  const [arcLinkLabelsColor, setArcLinkLabelsColor] = useState(graphProps?.arcLinkLabelsColor || "rgb(0, 0, 0)")
  const [anchor, setAnchor] = useState(graphProps?.anchor || "bottom")
  const [legDirection, setLegDirection] = useState(graphProps?.legDirection || "row")
  const [legendTranslateX, setLegendTranslateX] = useState(graphProps?.legendTranslateX || 0);
  const [legendTranslateY, setLegendTranslateY] = useState(graphProps?.legendTranslateY || 56);
  const [legendItemSpacing, setLegendItemSpacing] = useState(graphProps?.legendItemSpacing || 0);
  const [legendSymbolSize, setLegendSymbolSize] = useState(graphProps?.legendSymbolSize || 18);
  const [itemDirection, setItemDirection] = useState(graphProps?.itemDirection || "left-to-right")
  
  const schems = ["nivo", "category10", "accent", "dark2", "paired", "set1"]
  const anchors = ["top-left", "top", "top-right", "left", "center", "right", "bottom", "bottom-middle", "bottom-right"]
  const itemDirections = ["left-to-right", "right-to-left", "top-to-bottom", "bottom-to-top"]

  const updateSchem = (value: string) => {
    setSchem(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({schem: value})
    }
  }

  const updateItemDirection = (value: string) => {
    setItemDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({itemDirection: value})
    }
  }

  const updateLegendTranslateX = (value: number) => {
    setLegendTranslateX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateX: value})
    }
  }

  const updateLegendSymbolSize = (value: number) => {
    setLegendSymbolSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendSymbolSize: value})
    }
  }

  const updateLegendItemSpacing = (value: number) => {
    setLegendItemSpacing(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendItemSpacing: value})
    }
  }

  const updateLegendTranslateY = (value: number) => {
    setLegendTranslateY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateY: value})
    }
  }

  const updateLegDirection = (value: string) => {
    setLegDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legDirection: value})

    } 
  }

  const updateLabelsCol = (value: string) => {
    setLabelsCol(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLabelsTextColor: value})
    }
  }

  const updateAnchor = (value: string) => {
    setAnchor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({anchor: value})
    }
  }

  const updateArcLinkLabelsTextColor = (value: string) => {
    setArcLinkLabelsTextColor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsTextColor: value})
    }
  }

  const updateArcLinkLabelsColor = (value: string) => {
    setArcLinkLabelsColor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsColor: value})
    }
  }

  const updateEnableArcLabels = (value: boolean) => {
    setEnableArcLabels(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableArcLabels: value})
    }
  }

  const updateIsAnimate = (value: boolean) => {
    setIsAnimate(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({animate: value})
    }
  }

  const updateIsInteractive = (value: boolean) => {
    setIsInteractive(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isInteractive: value})
    }
  }

  const updateEnableArcLinkLabels = (value: boolean) => {
    setEnableArcLinkLabels(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableArcLinkLabels: value})
    }
  }

  const updateBorderCol = (value: string) => {
    setBorderCol(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({borderColor: value})
    }
  }

  const updateInnerRadius = (value: number) => {
    setInnerRadius(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({innerRadius: value})
    }
  }

  const updateArcLabelRadiusOffset = (value: number) => {
    setArcLabelsRadiusOffset(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLabelsRadiusOffset: value})
    }
  }

  const updateArcLinkLabelsDiagonalLength = (value: number) => {
    setArcLinkLabelsDiagonalLength(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsDiagonalLength: value})
    }
  }

  const updateArcLinkLabelsThickness = (value: number) => {
    setArcLinkLabelsThickness(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsThickness: value})
    }
  }

  const updateArcLinkLabelsTextOffset = (value: number) => {
    setArcLinkLabelsTextOffset(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsTextOffset: value})
    }
  }

  const updateArcLinkLabelsStraightLength = (value: number) => {
    setArcLinkLabelsStraightLength(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsStraightLength: value})
    }
  }

  const updateArcLabelSkipAngle = (value: number) => {
    setArcLabelsSkipAngle(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLabelsSkipAngle: value})
    }
  }

  const updateArcLinkLabelSkipAngle = (value: number) => {
    setArcLinkLabelsSkipAngle(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({arcLinkLabelsSkipAngle: value})
    }
  }

  const updateBorderWidth = (value: number) => {
    setBorderWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({borderWidth: value})
    }
  }

  const updateStartAngle = (value: number) => {
    setStartAngle(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({startAngle: value})
    }
  }

  const updateEndAngle = (value: number) => {
    setEndAngle(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({endAngle: value})
    }
  }

  const updatePadAngle = (value: number) => {
    setPadAngle(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({padAngle: value})
    }
  }

  const updateCornerRadius = (value: number) => {
    setCornerRadius(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({cornerRadius: value})
    }
  }

  return (
    <Box m="20px">
      <Header title="Pie Chart" subtitle="Simple Pie Chart" />
      <Box style={{display: "flex", justifyContent: "right", paddingRight: "50px"}}>
              <Button
                sx={{
                  backgroundColor: colors.blueAccent[700],
                  color: colors.grey[100],
                  fontSize: "14px",
                  fontWeight: "bold",
                  padding: "5px 20px",
                }}
                onClick={() => {
                  closeModal()
                }}
              >
                Close
              </Button>
            </Box>

      <div style={{display: "flex", flexDirection: "row"}}>
        <Box height="65vh" width="60vw">
          <Graph
            colors={graph.colors}
            type={graph.type}
            dataType={graph.dataType}
            rows={3}
            graphProps={{
              innerRadius: innerRadius,
              startAngle: startAngle,
              endAngle: endAngle,
              padAngle: padAngle,
              cornerRadius: cornerRadius,
              schem: schem,
              borderWidth: borderWidth,
              borderColor: borderCol,
              enableArcLabels: enableArcLabels,
              arcLabelsRadiusOffset: arcLabelsRadiusOffset,
              arcLabelsSkipAngle: arcLabelsSkipAngle,
              arcLabelsTextColor: labelsCol,
              enableArcLinkLabels: enableArcLinkLabels,
              arcLinkLabelsSkipAngle: arcLinkLabelsSkipAngle,
              arcLinkLabelsDiagonalLength: arcLinkLabelsDiagonalLength,
              arcLinkLabelsStraightLength: arcLinkLabelsStraightLength,
              arcLinkLabelsTextOffset: arcLinkLabelsTextOffset,
              arcLinkLabelsThickness: arcLinkLabelsThickness,
              arcLinkLabelsTextColor: arcLinkLabelsTextColor,
              arcLinkLabelsColor: arcLinkLabelsColor,
              isInteractive: isInteractive,
              animate: isAnimate,
              anchor: anchor,
              legDirection: legDirection,
              legendTranslateX: legendTranslateX,
              legendTranslateY: legendTranslateY,
              legendItemSpacing: legendItemSpacing,
              legendSymbolSize: legendSymbolSize,
              itemDirection: itemDirection,
            }}
          />
        </Box>

        <Box width="30vw" height="65vh" marginLeft="80px" overflow="auto">
          <Typography variant="h1" color={colors.grey[100]} fontWeight="bold">Settings</Typography>
          <Typography variant="h2" color={colors.grey[100]} margin={1}>Base</Typography>
          <NonLinearSlider title="Inner Radius" text="" min={0} max={0.95} step={0.05} pad={innerRadius} updateData={updateInnerRadius}/>
          <NonLinearSlider title="Start Angle" text="°" min={-180} max={360} step={1} pad={startAngle} updateData={updateStartAngle}/>
          <NonLinearSlider title="End Angle" text="°" min={-360} max={360} step={1} pad={endAngle} updateData={updateEndAngle}/>
          <NonLinearSlider title="Pad Angle" text="°" min={0} max={45} step={1} pad={padAngle} updateData={updatePadAngle}/>
          <NonLinearSlider title="Corner Radius" text="px" min={0} max={45} step={1} pad={cornerRadius} updateData={updateCornerRadius}/>

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Style</Typography>
          <Selector title="Colors theme" names={schems} mainName={schem} updateData={updateSchem}/>
          <NonLinearSlider title="Border Width" text="px" min={0} max={20} step={1} pad={borderWidth} updateData={updateBorderWidth}/>
          <ColorInput title="Border Color" col={borderCol} updateData={updateBorderCol}/>

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Arc Labels</Typography>
          <SettingBlock title="Enable Arc Labels" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableArcLabels} updateData={updateEnableArcLabels}/>  
          <NonLinearSlider title="Arc Labels Radius" text="" min={0} max={2} step={0.05} pad={arcLabelsRadiusOffset} updateData={updateArcLabelRadiusOffset}/>
          <NonLinearSlider title="Arc Labels Skip" text="°" min={0} max={180} step={1} pad={arcLabelsSkipAngle} updateData={updateArcLabelSkipAngle}/>
          <ColorInput title="Arc Labels Color" col={labelsCol} updateData={updateLabelsCol}/>

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Arc Link Labels</Typography>
          <SettingBlock title="Enable Arc Link Labels" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableArcLinkLabels} updateData={updateEnableArcLinkLabels}/>  
          <NonLinearSlider title="Arc Link Labels Skip" text="°" min={0} max={180} step={1} pad={arcLinkLabelsSkipAngle} updateData={updateArcLinkLabelSkipAngle}/>
          <NonLinearSlider title="Arc Link Labels Diagonal" text="px" min={0} max={50} step={1} pad={arcLinkLabelsDiagonalLength} updateData={updateArcLinkLabelsDiagonalLength}/>
          <NonLinearSlider title="Arc Link Labels Straight" text="px" min={0} max={50} step={1} pad={arcLinkLabelsStraightLength} updateData={updateArcLinkLabelsStraightLength}/>
          <NonLinearSlider title="Arc Link Labels Text Offset" text="px" min={0} max={50} step={1} pad={arcLinkLabelsTextOffset} updateData={updateArcLinkLabelsTextOffset}/>
          <NonLinearSlider title="Arc Link Labels Thickness" text="px" min={0} max={20} step={1} pad={arcLinkLabelsThickness} updateData={updateArcLinkLabelsThickness}/>
          <ColorInput title="Arc Link Labels Text Color" col={arcLinkLabelsTextColor} updateData={updateArcLinkLabelsTextColor}/>
          <ColorInput title="Arc Link Labels Color" col={arcLinkLabelsColor} updateData={updateArcLinkLabelsColor}/>

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Interactivity</Typography>
          <SettingBlock title="Is Inter" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isInteractive} updateData={updateIsInteractive}/>  

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Motion</Typography>
          <SettingBlock title="Is animate" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isAnimate} updateData={updateIsAnimate}/>  

          <Typography variant="h2" color={colors.grey[100]} margin={1}>Legend</Typography>
          <Selector title="Anchor" names={anchors} mainName={anchor} updateData={updateAnchor}/>
          <SettingBlock title="Direction" nameParam1="column" nameParam2="row" valParam1="column" valParam2="row" value={legDirection} updateData={updateLegDirection}/>  
          <NonLinearSlider title="Translate X" text="px" min={-200} max={200} step={1} pad={legendTranslateX} updateData={updateLegendTranslateX}/>
          <NonLinearSlider title="Translate Y" text="px" min={-200} max={200} step={1} pad={legendTranslateY} updateData={updateLegendTranslateY}/>
          <NonLinearSlider title="Item spacing" text="px" min={0} max={50} step={1} pad={legendItemSpacing} updateData={updateLegendItemSpacing}/>
          <NonLinearSlider title="Symbol size" text="px" min={2} max={50} step={1} pad={legendSymbolSize} updateData={updateLegendSymbolSize}/>
          <Selector title="Item direction" names={itemDirections} mainName={itemDirection} updateData={updateItemDirection}/>
        </Box>
      </div>
    </Box>
  );
};

export default Pie;