import { Box, useTheme, Typography, Button } from "@mui/material";
import Header from "../../../components/Header";
import { tokens } from "../../../theme";
import { useState, useContext } from "react";
import { SettingBlock } from "../../../components/SettingBlock";
import Selector from "../../../components/Selector";
import { NonLinearSlider } from "../../../components/NonLinearSlider";
import ColorInput from "../../../components/ColorInput";
import { ILINE_PROPS } from "../../../constants/graphProps";
import Graph from "../../../components/Graph";
import { ModalContext } from '../../../context/ModalContext';

const Line = ({
  graph,
  onChangeGraphProps,
  graphProps,
}
:
{
  graph?: any,
  onChangeGraphProps?: (newProps: ILINE_PROPS) => null,
  graphProps?: ILINE_PROPS,
}
) => {

  const theme = useTheme()
  const colors = tokens(theme.palette.mode)
  const {close: closeModal} = useContext(ModalContext)

  const curves = ["basis", "cardinal", "catmullRom", "linear", "monotoneX", "monotoneY", "natural", "step", "stepAfter", "stepBefore"]
  const schems = ["nivo", "category10", "accent", "dark2", "paired", "set1"]
  const pointLabels = ["x", "y"]
  const anchors = ["top-left", "top", "top-right", "left", "center", "right", "bottom-left", "bottom", "bottom-right"]
  const itemDirections = ["left-to-right", "right-to-left", "top-to-bottom", "bottom-to-top"]

  const [xScaleType, setXScaleType] = useState(graphProps?.xScaleType || "point");
  const [yScaleType, setYScaleType] = useState(graphProps?.yScaleType || "linear");
  const [curve, setCurve] = useState(graphProps?.curve || "linear");
  const [schem, setSchem] = useState(graphProps?. schem || "nivo")
  const [lineWidth, setLineWidth] = useState(graphProps?.lineWidth || 2)
  const [enableArea, setEnableArea] = useState(graphProps?.enableArea || false)
  const [areaOpacity, setAreaOpacity] = useState(graphProps?. areaOpacity || 0.2)
  const [enablePoints, setEnablePoints] = useState(graphProps?.enablePoints || true)
  const [pointSize, setPointSize] = useState(graphProps?.pointSize || 8)
  const [pointColor, setPointColor] = useState(graphProps?.pointColor || "rgb(255, 255, 255)")
  const [pointBorderWidth, setPointBorderWidth] = useState(graphProps?.pointBorderWidth || 2)
  const [enablePointLabel, setEnablePointLabel] = useState(graphProps?.enablePointLabel || false)
  const [pointLabel, setPointLabel] = useState(graphProps?.pointLabel || "y")
  const [pointLabelYOffset, setPointLabelYOffset] = useState(graphProps?.pointLabelYOffset || -12)
  const [enableGridX, setEnableGridX] = useState(graphProps?.enableGridX || false);
  const [enableGridY, setEnableGridY] = useState(graphProps?.enableGridY || true);
  const [enableAxisTop, setEnableAxisTop] = useState(graphProps?.axisTop || false);
  const [enableAxisRight, setEnableAxisRight] = useState(graphProps?.axisRight || false);
  const [isInteractive, setIsInteractive] = useState(graphProps?.isInteractive || true);
  const [useMesh, setUseMesh] = useState(graphProps?.useMesh || true);
  const [isAnimate, setIsAnimate] = useState(graphProps?.animate || true);
  const [legDirection, setLegDirection] = useState(graphProps?.legDirection || "column")
  const [legendTranslateX, setLegendTranslateX] = useState(graphProps?.legendTranslateX || 100);
  const [legendTranslateY, setLegendTranslateY] = useState(graphProps?.legendTranslateY || 0);
  const [legendItemSpacing, setLegendItemSpacing] = useState(graphProps?.legendItemSpacing || 2);
  const [legendSymbolSize, setLegendSymbolSize] = useState(graphProps?.legendSymbolSize || 20);
  const [anchor, setAnchor] = useState(graphProps?.anchor || "bottom-right")
  const [itemDirection, setItemDirection] = useState(graphProps?.itemDirection || "left-to-right")

  const [isDashboard, setIsDashboard] = useState(graphProps?.isDashboard || false)
  const [showXName, setShowXName] = useState(graphProps?.showXName || false)
  const [showYName, setShowYName] = useState(graphProps?.showYName || false)

  const updateLineWidth = (value: number) => {
    setLineWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({lineWidth: value})
    }
  }

  const updateIsDashboard = (value: boolean) => {
    setIsDashboard(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isDashboard: value})
    }
  }

  const updateShowXName = (value: boolean) => {
    setShowXName(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({showXName: value})
    }
  }

  const updateShowYName = (value: boolean) => {
    setShowYName(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({showYName: value})
    }
  }

  const updateLegDirection = (value: string) => {
    setLegDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legDirection: value})
    }
  }

  const updateAnchor = (value: string) => {
    setAnchor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({anchor: value})
    }
  }

  const updateItemDirection = (value: string) => {
    setItemDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({itemDirection: value})
    }
  }

  const updateLegendTranslateX = (value: number) => {
    setLegendTranslateX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateX: value})
    }
  }

  const updateLegendSymbolSize = (value: number) => {
    setLegendSymbolSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendSymbolSize: value})
    }
  }

  const updateLegendItemSpacing = (value: number) => {
    setLegendItemSpacing(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendItemSpacing: value})
    }
  }

  const updateLegendTranslateY = (value: number) => {
    setLegendTranslateY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateY: value})
    }
  }

  const updateIsInteractive = (value: boolean) => {
    setIsInteractive(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isInteractive: value})
    }
  }

  const updateIsAnimate = (value: boolean) => {
    setIsAnimate(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({animate: value})
    }
  }

  const updateUseMesh = (value: boolean) => {
    setUseMesh(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({useMesh: value})
    }
  }

  const updatePointBorderWidth = (value: number) => {
    setPointBorderWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pointBorderWidth: value})
    }
  }

  const updatePointLabelYOffset = (value: number) => {
    setPointLabelYOffset(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pointLabelYOffset: value})
    }
  }

  const updatePointColor = (value: string) => {
    setPointColor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pointColor: value})
    }
  }

  const updatePointLabel = (value: string) => {
    setPointLabel(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pointLabel: value})
    }
  }

  const updatePointSize = (value: number) => {
    setPointSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pointSize: value})
    }
  }

  const updateAreaOpacity = (value: number) => {
    setAreaOpacity(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({areaOpacity: value})
    }
  }

  const updateEnableArea = (value: boolean) => {
    setEnableArea(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableArea: value})
    }
  }

  const updateEnablePoints = (value: boolean) => {
    setEnablePoints(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enablePoints: value})
    }
  }

  const updateEnablePointLabel = (value: boolean) => {
    setEnablePointLabel(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enablePointLabel: value})
    }
  }

  const updateXScaleType = (value: string) => {
    setXScaleType(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({xScaleType: value})
    }
  }

  const updateSchem = (value: string) => {
    setSchem(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({schem: value})
    }
  }

  const updateYScaleType = (value: string) => {
    setYScaleType(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({yScaleType: value})
    }
  }

  const updateCurve = (value: string) => {
    setCurve(value)
    
    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({curve: value})
    }
  }

  const updateEnableGridX = (value: boolean) => {
    setEnableGridX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableGridX: value})
    }
  }

  const updateEnableGridY = (value: boolean) => {
    setEnableGridY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableGridY: value})
    }
  }

  const updateEnableAxisTop = (value: boolean) => {
    setEnableAxisTop(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({axisTop: value})
    }
  }

  const updateEnableAxisRight = (value: boolean) => {
    setEnableAxisRight(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({axisRight: value})
    }
  }

  return (
    <Box m="20px">
      <Header title="Line Chart" subtitle="Simple Line Chart" />
      <Box style={{display: "flex", justifyContent: "right", paddingRight: "50px"}}>
              <Button
                sx={{
                  backgroundColor: colors.blueAccent[700],
                  color: colors.grey[100],
                  fontSize: "14px",
                  fontWeight: "bold",
                  padding: "5px 20px",
                }}
                onClick={() => {
                  closeModal()
                }}
              >
                Close
              </Button>
            </Box>
      <div style={{display: "flex", flexDirection: "row"}}>

      <Box height="65vh" width="60vw" marginRight="20px">
        <Graph
          colors={graph.colors}
          type={graph.type}
          dataType={graph.dataType}
          rows={3}
          graphProps={{
            isDashboard: isDashboard,
            showXName: showXName,
            showYName: showYName,
            xScaleType: xScaleType,
            yScaleType: yScaleType,
            curve: curve,
            schem: schem,
            lineWidth: lineWidth,
            enableArea: enableArea,
            areaOpacity: areaOpacity,
            enablePoints: enablePoints,
            pointSize: pointSize,
            pointColor: pointColor,
            pointBorderWidth: pointBorderWidth,
            enablePointLabel: enablePointLabel,
            pointLabel: pointLabel,
            pointLabelYOffset: pointLabelYOffset,
            enableGridX: enableGridX,
            enableGridY: enableGridY,
            axisTop: enableAxisTop,
            axisRight: enableAxisRight,
            isInteractive: isInteractive,
            useMesh: useMesh,
            animate: isAnimate,
            legDirection: legDirection,
            legendTranslateX: legendTranslateX,
            legendTranslateY: legendTranslateY,
            anchor: anchor,
            legendItemSpacing: legendItemSpacing,
            legendSymbolSize: legendSymbolSize,
            itemDirection: itemDirection,
          }}
        />
      </Box>
      <Box width="30vw" height="65vh" marginLeft="80px" overflow="auto">
        <Typography variant="h1" color={colors.grey[100]} fontWeight="bold">Settings</Typography>
        <Typography variant="h2" color={colors.grey[100]} margin={1}>Base</Typography>
        <SettingBlock title="Show Legend" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={isDashboard} updateData={updateIsDashboard}/> 
        <SettingBlock title="Show name X" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={showXName} updateData={updateShowXName}/>  
        <SettingBlock title="Show name Y" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={showYName} updateData={updateShowYName}/>  
        <SettingBlock title="XScale Type" nameParam1="linear" nameParam2="point" valParam1="linear" valParam2="point" value={xScaleType} updateData={updateXScaleType}/>  
        <SettingBlock title="YScale Type" nameParam1="linear" nameParam2="point" valParam1="linear" valParam2="point" value={yScaleType} updateData={updateYScaleType}/>  

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Style</Typography>
        <Selector title="Curve" names={curves} mainName={curve} updateData={updateCurve}/>
        <Selector title="Colors theme" names={schems} mainName={schem} updateData={updateSchem}/>
        <NonLinearSlider title="Line Width" text="px" min={0} max={20} step={1} pad={lineWidth} updateData={updateLineWidth}/>
        <SettingBlock title="Enable Area" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableArea} updateData={updateEnableArea}/>  
        <NonLinearSlider title="Area Opacity" text="" min={0} max={1} step={0.05} pad={areaOpacity} updateData={updateAreaOpacity}/>

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Points</Typography>
        <SettingBlock title="Enable Points" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enablePoints} updateData={updateEnablePoints}/>  
        <NonLinearSlider title="Point Size" text="px" min={2} max={30} step={1} pad={pointSize} updateData={updatePointSize}/>
        <ColorInput title="Border Color" col={pointColor} updateData={updatePointColor}/>
        <NonLinearSlider title="Point Border Width" text="px" min={0} max={30} step={1} pad={pointBorderWidth} updateData={updatePointBorderWidth}/>
        <SettingBlock title="Enable Point Label" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enablePointLabel} updateData={updateEnablePointLabel}/>  
        <Selector title="Point Label" names={pointLabels} mainName={pointLabel} updateData={updatePointLabel}/>
        <NonLinearSlider title="Point Label Y Offset" text="px" min={-24} max={24} step={1} pad={pointLabelYOffset} updateData={updatePointLabelYOffset}/>

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Grid & Axes</Typography>
        <SettingBlock title="Enable GridX" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableGridX} updateData={updateEnableGridX}/>  
        <SettingBlock title="Enable GridY" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableGridY} updateData={updateEnableGridY}/>  
        <SettingBlock title="Enable Axis Top" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableAxisTop} updateData={updateEnableAxisTop}/> 
        <SettingBlock title="Enable Axis Right" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableAxisRight} updateData={updateEnableAxisRight}/>  

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Interactivity</Typography>
        <SettingBlock title="Is Interactive" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isInteractive} updateData={updateIsInteractive}/>  
        <SettingBlock title="Use mesh" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={useMesh} updateData={updateUseMesh}/>  

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Motion</Typography>
        <SettingBlock title="Is animate" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isAnimate} updateData={updateIsAnimate}/>  

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Legend</Typography>
        <SettingBlock title="Direction" nameParam1="column" nameParam2="row" valParam1="column" valParam2="row" value={legDirection} updateData={updateLegDirection}/>  
        <NonLinearSlider title="Translate X" text="px" min={-200} max={200} step={1} pad={legendTranslateX} updateData={updateLegendTranslateX}/>
        <NonLinearSlider title="Translate Y" text="px" min={-200} max={200} step={1} pad={legendTranslateY} updateData={updateLegendTranslateY}/>
        <Selector title="Anchor" names={anchors} mainName={anchor} updateData={updateAnchor}/>
        <NonLinearSlider title="Item spacing" text="px" min={0} max={50} step={1} pad={legendItemSpacing} updateData={updateLegendItemSpacing}/>
        <NonLinearSlider title="Symbol size" text="px" min={2} max={50} step={1} pad={legendSymbolSize} updateData={updateLegendSymbolSize}/>
        <Selector title="Item direction" names={itemDirections} mainName={itemDirection} updateData={updateItemDirection}/>
      </Box>
      </div>
    </Box>
  );
};

export default Line;