import { Box, useTheme, Typography, Button } from "@mui/material";
import Header from "../../../components/Header";
import { tokens } from "../../../theme";
import { useState, useContext } from "react";
import { SettingBlock } from "../../../components/SettingBlock";
import Selector from "../../../components/Selector";
import { NonLinearSlider } from "../../../components/NonLinearSlider";
import ColorInput from "../../../components/ColorInput";
import { IBULLET_PROPS } from "../../../constants/graphProps";
import Graph from "../../../components/Graph";
import { ModalContext } from '../../../context/ModalContext';

const Bullet = ({
  graph,
  onChangeGraphProps,
  graphProps,
}
:
{
  graph?: any,
  onChangeGraphProps?: (newProps: IBULLET_PROPS) => null,
  graphProps?: IBULLET_PROPS,
} 
) => {

  const theme = useTheme()
  const colors = tokens(theme.palette.mode)
  const {close: closeModal} = useContext(ModalContext)

  const rangeThemes = ["cool", "warm", "viridis", "inferno", "magma", "plasma", "rainbow", "sinebow"]

  const [layout, setLayout] = useState(graphProps?.layout || "horizontal");
  const [reverse, setReverse] = useState(graphProps?.reverse || false);
  const [measureSize, setMeasureSize] = useState(graphProps?.measureSize || 0.4)
  const [markerSize, setMarkerSize] = useState(graphProps?.markerSize || 0.6)
  const [rangeBorderWidth, setRangeBorderWidth] = useState(graphProps?.rangeBorderWidth || 0)
  const [rangeBorderColor, setRangeBorderColor] = useState(graphProps?.rangeBorderColor || "rgb(0, 0, 0)")
  const [rangeColors, setRangeColors] = useState(graphProps?.rangeColors || "cool")
  const [measureBorderWidth, setMeasureBorderWidth] = useState(graphProps?.measureBorderWidth || 0)
  const [measureBorderColor, setMeasureBorderColor] = useState(graphProps?.measureBorderColor || "rgb(0, 0, 0)")
  const [markerColors, setMarkerColors] = useState(graphProps?.markerColor || "inferno")
  const [axesPosition, setAxesPosition] = useState(graphProps?.axesPosition || "after")
  const [titlePosition, setTitlePosition] = useState(graphProps?.titlePosition || "before")
  const [titleOffsetX, setTitleOffsetX] = useState(graphProps?.titleOffsetX || -50)
  const [titleOffsetY, setTitleOffsetY] = useState(graphProps?.titleOffsetY || 0)
  const [titleRotation, setTitleRotation] = useState(graphProps?.titleRotation || 0)
  const [isAnimate, setIsAnimate] = useState(graphProps?.animate || true);
  const [isInteractive, setIsInteractive] = useState(graphProps?.isInteractive || true);

  const [height, setHeight] = useState("25%")
  const [width, setWidth] = useState("90%")

  const updateIsInteractive = (value: boolean) => {
    setIsInteractive(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isInteractive: value})
    }
  }

  const updateLayout = (value: string) => {
    setLayout(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({layout: value})
    }
  }

  const updateAxesPosition = (value: string) => {
    setAxesPosition(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({axesPosition: value})
    }
  }

  const updateTitlePosition = (value: string) => {
    setTitlePosition(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({titlePosition: value})
    }
  }

  const updateRangeColors = (value: string) => {
    setRangeColors(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({rangeColors: value})
    }
  }

  const updateMarkerColors = (value: string) => {
    setMarkerColors(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({markerColor: value})
    }
  }

  const updateRangeBorderColor = (value: string) => {
    setRangeBorderColor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({rangeBorderColor: value})
    }
  }

  const updateMeasureBorderColor = (value: string) => {
    setMeasureBorderColor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({measureBorderColor: value})
    }
  }

  const updateReverse = (value: boolean) => {
    setReverse(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({reverse: value})
    }
  }

  const updateTitleOffsetX = (value: number) => {
    setTitleOffsetX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({titleOffsetX: value})
    }
  }

  const updateTitleRotation = (value: number) => {
    setTitleRotation(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({titleRotation: value})
    }
  }

  const updateTitleOffsetY = (value: number) => {
    setTitleOffsetY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({titleOffsetY: value})
    }
  }

  const updateMeasureSize = (value: number) => {
    setMeasureSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({measureSize: value})
    }
  }

  const updateMarkerSize = (value: number) => {
    setMarkerSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({markerSize: value})
    }
  }

  const updateRangeBorderWidth = (value: number) => {
    setRangeBorderWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({rangeBorderWidth: value})
    }
  }

  const updateMeasureBorderWidth = (value: number) => {
    setMeasureBorderWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({measureBorderWidth: value})
    }
  }

  const updateIsAnimate = (value: boolean) => {
    setIsAnimate(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({animate: value})
    }
  }

  return (
    <Box m="20px">
      <Header title="Bullet Chart" subtitle="Simple Bullet Chart" />
      <Box style={{display: "flex", justifyContent: "right", paddingRight: "50px"}}>
              <Button
                sx={{
                  backgroundColor: colors.blueAccent[700],
                  color: colors.grey[100],
                  fontSize: "14px",
                  fontWeight: "bold",
                  padding: "5px 20px",
                }}
                onClick={() => {
                  closeModal()
                }}
              >
                Close
              </Button>
            </Box>
      <div style={{display: "flex", flexDirection: "row"}}>
      <Box width="60vw" display="flex" justifyContent="center" alignItems="center">
      <Box
        height="90%"
        width="90%"
      >
        <Graph
          colors={graph.colors}
          type={graph.type}
          dataType={graph.dataType}
          rows={3}
          graphProps={{
            layout: layout,
            reverse: reverse,
            measureSize: measureSize,
            markerSize: markerSize,
            rangeBorderWidth: rangeBorderWidth,
            rangeBorderColor: rangeBorderColor,
            rangeColors: rangeColors,
            measureBorderWidth: measureBorderWidth,
            measureBorderColor: measureBorderColor,
            markerColor: markerColors,
            axesPosition: axesPosition,
            titlePosition: titlePosition,
            titleOffsetX: titleOffsetX,
            titleOffsetY: titleOffsetY,
            titleRotation: titleRotation,
            animate: isAnimate,
            isInteractive: isInteractive,
          }}
        />
      </Box>
    </Box>
      <Box width="30vw" height="30vw" marginLeft="80px" overflow="auto">
        <Typography variant="h1" color={colors.grey[100]} fontWeight="bold">Settings</Typography>
        <Typography variant="h2" color={colors.grey[100]} margin={1}>Base</Typography>
        <SettingBlock title="Layout" nameParam1="vertical" nameParam2="horizontal" valParam1="vertical" valParam2="horizontal" value={layout} updateData={updateLayout}/>
        <SettingBlock title="Reverse" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={reverse} updateData={updateReverse}/>
        <NonLinearSlider title="Measure Size" text="" min={0} max={1} step={0.1} pad={measureSize} updateData={updateMeasureSize}/>
        <NonLinearSlider title="Marker Size" text="" min={0} max={2} step={0.1} pad={markerSize} updateData={updateMarkerSize}/>
      
        <Typography variant="h2" color={colors.grey[100]} margin={1}>Style</Typography>
        <NonLinearSlider title="Border Width" text="px" min={0} max={20} step={1} pad={rangeBorderWidth} updateData={updateRangeBorderWidth}/>
        <ColorInput title="Border Color" col={rangeBorderColor} updateData={updateRangeBorderColor}/>
        <Selector title="Range Colors" names={rangeThemes} mainName={rangeColors} updateData={updateRangeColors}/>
        <NonLinearSlider title="Measure Border Width" text="px" min={0} max={20} step={1} pad={measureBorderWidth} updateData={updateMeasureBorderWidth}/>
        <ColorInput title="Measure Border Color" col={measureBorderColor} updateData={updateMeasureBorderColor}/>
        <Selector title="Marker Colors" names={rangeThemes} mainName={markerColors} updateData={updateMarkerColors}/>

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Axes</Typography>
        <SettingBlock title="Axes Position" nameParam1="before" nameParam2="after" valParam1="before" valParam2="after" value={axesPosition} updateData={updateAxesPosition}/>
      
        <Typography variant="h2" color={colors.grey[100]} margin={1}>Title</Typography>
        <SettingBlock title="Title Position" nameParam1="before" nameParam2="after" valParam1="before" valParam2="after" value={titlePosition} updateData={updateTitlePosition}/>
        <NonLinearSlider title="Title Offset X" text="px" min={-100} max={100} step={1} pad={titleOffsetX} updateData={updateTitleOffsetX}/>
        <NonLinearSlider title="Title Offset Y" text="px" min={-100} max={100} step={1} pad={titleOffsetY} updateData={updateTitleOffsetY}/>
        <NonLinearSlider title="Title Rotation" text="°" min={-360} max={360} step={1} pad={titleRotation} updateData={updateTitleRotation}/>
      
        <Typography variant="h2" color={colors.grey[100]} margin={1}>Interactivity</Typography>
        <SettingBlock title="Is Interactive" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isInteractive} updateData={updateIsInteractive}/>  

        <Typography variant="h2" color={colors.grey[100]} margin={1}>Motion</Typography>
        <SettingBlock title="Is animate" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isAnimate} updateData={updateIsAnimate}/>  
      </Box>
      </div>
    </Box>
  );
};

export default Bullet;