import { Box, Button, Typography, useTheme } from "@mui/material";
import Header from "../../../components/Header";
import { useState, useContext } from "react";
import { SettingBlock } from "../../../components/SettingBlock";
import { NonLinearSlider } from "../../../components/NonLinearSlider";
import { tokens } from "../../../theme";
import ColorInput from "../../../components/ColorInput";
import Selector from "../../../components/Selector";
import { IBAR_PROPS } from "../../../constants/graphProps";
import Graph from "../../../components/Graph";
import { ModalContext } from '../../../context/ModalContext';

const Bar = ({
  graph,
  onChangeGraphProps,
  graphProps,
}
:
{
  graph?: any,
  onChangeGraphProps?: (arg: IBAR_PROPS) => null,
  graphProps?: IBAR_PROPS,
}
) => {

  const {close: closeModal} = useContext(ModalContext)
  const theme = useTheme()
  const colors = tokens(theme.palette.mode)

  const [isDashboard, setIsDashboard] = useState(graphProps?.isDashboard || false);
  const [showXName, setShowXName] = useState(graphProps?.showXName || false);
  const [showYName, setShowYName] = useState(graphProps?.showYName || false);
  const [group, setGroup] = useState(graphProps?.group || "grouped");
  const [layout, setLayout] = useState(graphProps?.layout || "vertical");
  const [reverse, setReverse] = useState(graphProps?.reverse || false);
  const [enableLabel, setEnableLabel] = useState(graphProps?.enableLabel || false);
  const [enableGridX, setEnableGridX] = useState(graphProps?.enableGridX || false);
  const [enableGridY, setEnableGridY] = useState(graphProps?.enableGridY || true);
  const [isInteractive, setIsInteractive] = useState(graphProps?.isInteractive || true);
  const [isFocusable, setIsFocusable] = useState(graphProps?.isFocusable || false);
  const [pad, setPad] = useState(graphProps?.pad || 0.1);
  const [innerPad, setInnerPad] = useState(graphProps?.innerPad || 0);
  const [borderRad, setBorderRad] = useState(graphProps?.borderRad || 0);
  const [borderWidth, setBorderWidth] = useState(graphProps?.borderWidth || 0);
  const [borderCol, setBorderCol] = useState(graphProps?.borderCol || "rgb(0, 0, 0)")
  const [labelCol, setLabelCol] = useState(graphProps?.labelCol || "rgb(0, 0, 0)")
  const [schem, setSchem] = useState(graphProps?.schem || "nivo")
  const [legDirection, setLegDirection] = useState(graphProps?.legDirection || "column")
  const [legendTranslateX, setLegendTranslateX] = useState(graphProps?.legendTranslateX || 120);
  const [legendTranslateY, setLegendTranslateY] = useState(graphProps?.legendTranslateY || 0);
  const [legendItemSpacing, setLegendItemSpacing] = useState(graphProps?.legendItemSpacing || 2);
  const [legendSymbolSize, setLegendSymbolSize] = useState(graphProps?.legendSymbolSize || 20);
  const [anchor, setAnchor] = useState(graphProps?.anchor || "bottom-right")
  const [itemDirection, setItemDirection] = useState(graphProps?.itemDirection || "left-to-right")
  const [enableAxisTop, setEnableAxisTop] = useState(graphProps?.axisTop || false);
  const [enableAxisRight, setEnableAxisRight] = useState(graphProps?.axisRight || false);
  const [isAnimate, setIsAnimate] = useState(graphProps?.animate || true);

  const schems = ["nivo", "category10", "accent", "dark2", "paired", "set1"]
  const anchors = ["top-left", "top", "top-right", "left", "center", "right", "bottom-left", "bottom", "bottom-right"]
  const itemDirections = ["left-to-right", "right-to-left", "top-to-bottom", "bottom-to-top"]

  const updateSchem = (value: string) => {
    setSchem(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({schem: value})
    }
  }

  const updateIsDashboard = (value: boolean) => {
    setIsDashboard(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isDashboard: value})
    }
  }

  const updateShowXName = (value: boolean) => {
    setShowXName(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({showXName: value})
    }
  }

  const updateShowYName = (value: boolean) => {
    setShowYName(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({showYName: value})
    }
  }

  const updateAnchor = (value: string) => {
    setAnchor(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({anchor: value})
    }
  }

  const updateItemDirection = (value: string) => {
    setItemDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({itemDirection: value})
    }
  }

  const updateLegendTranslateX = (value: number) => {
    setLegendTranslateX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateX: value})
    }
  }

  const updateLegendSymbolSize = (value: number) => {
    setLegendSymbolSize(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendSymbolSize: value})
    }
  }

  const updateLegendItemSpacing = (value: number) => {
    setLegendItemSpacing(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendItemSpacing: value})
    }
  }

  const updateLegendTranslateY = (value: number) => {
    setLegendTranslateY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legendTranslateY: value})
    }
  }

  const updateGroup = (value: string) => {
    setGroup(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({group: value})
    }
  }

  const updateLegDirection = (value: string) => {
    setLegDirection(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({legDirection: value})
    }
  }

  const updateLayout = (value: string) => {
    setLayout(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({layout: value})
    }
  }

  const updateBorderCol = (value: string) => {
    setBorderCol(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({borderCol: value})
    }
  }

  const updateLabelCol = (value: string) => {
    setLabelCol(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({labelCol: value})
    }
  }

  const updateReverse = (value: boolean) => {
    setReverse(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({reverse: value})
    }
  }

  const updateIsInteractive = (value: boolean) => {
    setIsInteractive(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isInteractive: value})
    }
  }

  const updateIsFocusable = (value: boolean) => {
    setIsFocusable(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({isFocusable: value})
    }
  }

  const updateIsAnimate = (value: boolean) => {
    setIsAnimate(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({animate: value})
    }
  }

  const updateEnableLabel = (value: boolean) => {
    setEnableLabel(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableLabel: value})
    }
  }

  const updateEnableGridX = (value: boolean) => {
    setEnableGridX(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableGridX: value})
    }
  }

  const updateEnableGridY = (value: boolean) => {
    setEnableGridY(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({enableGridY: value})
    }
  }

  const updateEnableAxisTop = (value: boolean) => {
    setEnableAxisTop(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({axisTop: value})
    }
  }

  const updateEnableAxisRight = (value: boolean) => {
    setEnableAxisRight(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({axisRight: value})
    }
  }

  const updatePad = (value: number) => {
    setPad(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({pad: value})
    }
  }

  const updateInnerPad = (value: number) => {
    setInnerPad(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({innerPad: value})
    }
  }

  const updateBorderRad = (value: number) => {
    setBorderRad(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({borderRad: value})
    }
  }

  const updateBorderWidth = (value: number) => {
    setBorderWidth(value)

    if (onChangeGraphProps && graphProps) {
      onChangeGraphProps({borderWidth: value})
    }
  }

  return (
    <Box m="20px">
      <Header title="Bar Chart" subtitle="Simple Bar Chart" />
      <Box style={{display: "flex", justifyContent: "right", paddingRight: "50px"}}>
              <Button
                sx={{
                  backgroundColor: colors.blueAccent[700],
                  color: colors.grey[100],
                  fontSize: "14px",
                  fontWeight: "bold",
                  padding: "5px 20px",
                }}
                onClick={() => {
                  closeModal()
                }}
              >
                Close
              </Button>
            </Box>
      <div style={{display: "flex", flexDirection: "row"}}>

      <Box height="65vh" width="60vw">
      <Graph
          colors={graph.colors}
          type={graph.type}
          dataType={graph.dataType}
          rows={3}
          graphProps={{
            isDashboard: isDashboard,
            group: group,
            layout: layout,
            reverse: reverse,
            pad: pad,
            innerPad: innerPad,
            borderRad: borderRad,
            borderWidth: borderWidth,
            enableLabel: enableLabel,
            enableGridX: enableGridX,
            enableGridY: enableGridY,
            axisTop: enableAxisTop,
            axisRight: enableAxisRight,
            borderCol: borderCol,
            labelCol: labelCol,
            isInteractive: isInteractive,
            isFocusable: isFocusable,
            animate: isAnimate,
            schem: schem,
            legDirection: legDirection,
            legendTranslateX: legendTranslateX,
            legendTranslateY: legendTranslateY,
            anchor: anchor,
            legendItemSpacing: legendItemSpacing,
            legendSymbolSize: legendSymbolSize,
            itemDirection: itemDirection,
            showXName: showXName,
            showYName: showYName,
          }}
        />
      </Box>
            
      <Box width="30vw" height="65vh" marginLeft="80px" overflow="auto">
            <Typography variant="h1" color={colors.grey[100]} fontWeight="bold">Settings</Typography>
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Base</Typography>
            <SettingBlock title="Show Legend" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={isDashboard} updateData={updateIsDashboard}/> 
            <SettingBlock title="Show name X" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={showXName} updateData={updateShowXName}/>  
            <SettingBlock title="Show name Y" nameParam1="true" nameParam2="false" valParam1={false} valParam2={true} value={showYName} updateData={updateShowYName}/>  
            <SettingBlock title="Group Mode" nameParam1="grouped" nameParam2="stacked" valParam1="grouped" valParam2="stacked" value={group} updateData={updateGroup}/>  
            <SettingBlock title="Layout" nameParam1="vertical" nameParam2="horizontal" valParam1="vertical" valParam2="horizontal" value={layout} updateData={updateLayout}/>
            <SettingBlock title="Reverse" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={reverse} updateData={updateReverse}/>  
            <NonLinearSlider title="Padding" text="" min={0} max={0.9} step={0.1} pad={pad} updateData={updatePad}/>
            <NonLinearSlider title="Inner Padding" text="px" min={0} max={10} step={1} pad={innerPad} updateData={updateInnerPad}/>
            
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Style</Typography>
            <NonLinearSlider title="Border Radius" text="px" min={0} max={30} step={1} pad={borderRad} updateData={updateBorderRad}/>
            <NonLinearSlider title="Border Width" text="px" min={0} max={20} step={1} pad={borderWidth} updateData={updateBorderWidth}/>
            <ColorInput title="Border Color" col={borderCol} updateData={updateBorderCol}/>
            <Selector title="Colors theme" names={schems} mainName={schem} updateData={updateSchem}/>

            <Typography variant="h2" color={colors.grey[100]} margin={1}>Labels</Typography>
            <SettingBlock title="Enable Labels" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableLabel} updateData={updateEnableLabel}/>  
            <ColorInput title="Label Text Color" col={labelCol} updateData={updateLabelCol}/>
            
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Grid & Axis</Typography>
            <SettingBlock title="Enable GridX" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableGridX} updateData={updateEnableGridX}/>  
            <SettingBlock title="Enable GridY" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableGridY} updateData={updateEnableGridY}/>  
            <SettingBlock title="Enable Axis Top" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableAxisTop} updateData={updateEnableAxisTop}/> 
            <SettingBlock title="Enable Axis Right" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={enableAxisRight} updateData={updateEnableAxisRight}/>  
      
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Interactivity</Typography>
            <SettingBlock title="Is Interactive" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isInteractive} updateData={updateIsInteractive}/>  
      
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Accessibility</Typography>
            <SettingBlock title="Make bar item focusable" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isFocusable} updateData={updateIsFocusable}/>  
      
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Motion</Typography>
            <SettingBlock title="Is animate" nameParam1="true" nameParam2="false" valParam1={true} valParam2={false} value={isAnimate} updateData={updateIsAnimate}/>  
      
            <Typography variant="h2" color={colors.grey[100]} margin={1}>Legend</Typography>
            <SettingBlock title="Direction" nameParam1="column" nameParam2="row" valParam1="column" valParam2="row" value={legDirection} updateData={updateLegDirection}/>  
            <NonLinearSlider title="Translate X" text="px" min={-200} max={200} step={1} pad={legendTranslateX} updateData={updateLegendTranslateX}/>
            <NonLinearSlider title="Translate Y" text="px" min={-200} max={200} step={1} pad={legendTranslateY} updateData={updateLegendTranslateY}/>
            <Selector title="Anchor" names={anchors} mainName={anchor} updateData={updateAnchor}/>
            <NonLinearSlider title="Item spacing" text="px" min={0} max={50} step={1} pad={legendItemSpacing} updateData={updateLegendItemSpacing}/>
            <NonLinearSlider title="Symbol size" text="px" min={2} max={50} step={1} pad={legendSymbolSize} updateData={updateLegendSymbolSize}/>
            <Selector title="Item direction" names={itemDirections} mainName={itemDirection} updateData={updateItemDirection}/>
      </Box>
      </div>
    </Box>
  );
};

export default Bar;