export interface IProduct {
    id?: number
    serial_number: string
    ground_truth: boolean
    detail_id: number
    result_1: boolean
    result_2: boolean
    result_3: boolean
    result_4: boolean
    repeatability: boolean
    ground_truth_result: number
}

export interface IRealData {
    id: number
    serial_number: string
    batch_number: string
    timestamp: string
    product: string
    result: boolean
    defects: string
}

export interface IPerson {
    id?: number
    name: string
    email: string
    access: string 
}

export interface IBarData {
    "product": string
    "overroll": number
    "OK": number
    "rotation": number
    "gap - max": number
    "center - distance": number 
}

export interface ILineData {
    id: string
    data: { x: string; y: number; }[]
}

export interface ColorMode {
    colors: {
        grey: {
            100: string
            200: string
            300: string
            400: string
            500: string
            600: string
            700: string
            800: string
            900: string
        },
        primary: {
            100: string
            200: string
            300: string
            400: string
            500: string
            600: string
            700: string
            800: string
            900: string
        },
        greenAccent: {
            100: string
            200: string
            300: string
            400: string
            500: string
            600: string
            700: string
            800: string
            900: string
        },
        redAccent: {
            100: string
            200: string
            300: string
            400: string
            500: string
            600: string
            700: string
            800: string
            900: string
        },
        blueAccent: {
            100: string
            200: string
            300: string
            400: string
            500: string
            600: string
            700: string
            800: string
            900: string
        }
    }
}