const freeSpacePosition = (row, colsToInsert) => {
    let counter = 0

    for (let i = 0; i < row.length; i++) {
        if (row[i] === 1) {
            counter++
        }
        else {
            counter = 0
        }

        if (counter === colsToInsert) {
            return i + 1 - counter
        }
    }

    return -1
}

const canAddNewGraph = (addingCols, addingRows, max_width, max_height, graphList) => {
    const tableSim = new Array(max_height)

    for (let row = 0; row < max_height; row++) {
        tableSim[row] = new Array(max_width).fill(1)
    }

    let yPosition
    let heightLevel = 0

    graphList.forEach(graph => {
        for (let j = heightLevel; j < max_height; j++) {
          const pos = freeSpacePosition(tableSim[j], graph.cols)

          if (pos === -1) {
            continue
          }

          for (let i = 0; i < graph.rows; i++) {
            for (let t = 0; t < graph.cols; t++) {
                tableSim[j + i][pos + t] = 0
            }
          }

          heightLevel = j

          break
        }
    })

    for (let i = heightLevel; i < tableSim.length; i++) {
      if (freeSpacePosition(tableSim[i], addingCols) === -1) {
        continue
      }

      yPosition = i
      break
    }


    // We don't have enough width
    if (yPosition === undefined) {
      return false
    }

    // We don't have enough height
    if (yPosition + addingRows > max_height) {
      return false
    }

    return true
  }

export default canAddNewGraph