export interface IBAR_PROPS {
    isDashboard?: Boolean,
    group?: String,
    layout?: String,
    reverse?: Boolean,
    pad?: Number,
    innerPad?: Number,
    borderRad?: Number,
    borderWidth?: Number,
    enableLabel?: Boolean,
    enableGridX?: Boolean,
    enableGridY?: Boolean,
    axisTop?: Boolean,
    axisRight?: Boolean,
    borderCol?: String,
    labelCol?: String,
    isInteractive?: Boolean,
    isFocusable?: Boolean,
    animate?: Boolean,
    schem?: String,
    legDirection?: String,
    legendTranslateX?: Number,
    legendTranslateY?: Number,
    anchor?: String,
    legendItemSpacing?: Number,
    legendSymbolSize?: Number,
    itemDirection?: String,
    showXName?: Boolean,
    showYName?: Boolean,
}

export const BAR_PROPS: IBAR_PROPS = {
    isDashboard: false,
    group: "grouped",
    layout: "vertical",
    reverse: false,
    pad: 0.1,
    innerPad: 0,
    borderRad: 0,
    borderWidth: 0,
    enableLabel: false,
    enableGridX: false,
    enableGridY: true,
    axisTop: false,
    axisRight: false,
    borderCol: "rgb(0, 0, 0)",
    labelCol: "rgb(0, 0, 0)",
    isInteractive: true,
    isFocusable: false,
    animate: true,
    schem: "nivo",
    legDirection: "column",
    legendTranslateX: 120,
    legendTranslateY: 0,
    anchor: "bottom-right",
    legendItemSpacing: 2,
    legendSymbolSize: 20,
    itemDirection: "left-to-right",
    showXName: true,
    showYName: true,
}

export interface IPIE_PROPS {
    innerRadius?: Number,
    startAngle?: Number,
    endAngle?: Number,
    padAngle?: Number,
    cornerRadius?: Number,
    schem?: String,
    borderWidth?: Number,
    borderColor?: String,
    enableArcLabels?: Boolean,
    arcLabelsRadiusOffset?: Number,
    arcLabelsSkipAngle?: Number,
    arcLabelsTextColor?: String,
    enableArcLinkLabels?: Boolean,
    arcLinkLabelsSkipAngle?: Number,
    arcLinkLabelsDiagonalLength?: Number,
    arcLinkLabelsStraightLength?: Number,
    arcLinkLabelsTextOffset?: Number,
    arcLinkLabelsThickness?: Number,
    arcLinkLabelsTextColor?: String,
    arcLinkLabelsColor?: String,
    isInteractive?: Boolean,
    animate?: Boolean,
    anchor?: String,
    legDirection?: String,
    legendTranslateX?: Number,
    legendTranslateY?: Number,
    legendItemSpacing?: Number,
    legendSymbolSize?: Number,
    itemDirection?: String,
}

export const PIE_PROPS: IPIE_PROPS = {
    innerRadius: 0,
    startAngle: 0,
    endAngle: 360,
    padAngle: 0,
    cornerRadius: 0,
    schem: "nivo",
    borderWidth: 0,
    borderColor: "rgb(0, 0, 0)",
    enableArcLabels: false,
    arcLabelsRadiusOffset: 0.5,
    arcLabelsSkipAngle: 0,
    arcLabelsTextColor: "rgb(0, 0, 0)",
    enableArcLinkLabels: true,
    arcLinkLabelsSkipAngle: 0,
    arcLinkLabelsDiagonalLength: 16,
    arcLinkLabelsStraightLength: 24,
    arcLinkLabelsTextOffset: 6,
    arcLinkLabelsThickness: 1,
    arcLinkLabelsTextColor: "rgb(0, 0, 0)",
    arcLinkLabelsColor: "rgb(0, 0, 0)",
    isInteractive: true,
    animate: true,
    anchor: "bottom",
    legDirection: "row",
    legendTranslateX: 0,
    legendTranslateY: 56,
    legendItemSpacing: 0,
    legendSymbolSize: 18,
    itemDirection: "left-to-right",
}

export interface ILINE_PROPS {
    isDashboard?: Boolean,
    showXName?: Boolean,
    showYName?: Boolean,
    xScaleType?: String,
    yScaleType?: String,
    curve?: String,
    schem?: String,
    lineWidth?: Number,
    enableArea?: Boolean,
    areaOpacity?: Number,
    enablePoints?: Boolean,
    pointSize?: Number,
    pointColor?: String,
    pointBorderWidth?: Number,
    enablePointLabel?: Boolean,
    pointLabel?: String,
    pointLabelYOffset?: Number,
    enableGridX?: Boolean, 
    enableGridY?: Boolean, 
    axisTop?: Boolean, 
    axisRight?: Boolean,
    isInteractive?: Boolean,
    useMesh?: Boolean,
    animate?: Boolean,
    legDirection?: String,
    legendTranslateX?: Number,
    legendTranslateY?: Number,
    anchor?: String,
    legendItemSpacing?: Number,
    legendSymbolSize?: Number,
    itemDirection?: String,
}

export const LINE_PROPS: ILINE_PROPS = {
    isDashboard: false,
    showXName: false,
    showYName: false,
    xScaleType: "point",
    yScaleType: "linear",
    curve: "linear",
    schem: "nivo",
    lineWidth: 2,
    enableArea: false,
    areaOpacity: 0.2,
    enablePoints: true,
    pointSize: 8,
    pointColor: "rgb(255, 255, 255)",
    pointBorderWidth: 2,
    enablePointLabel: false,
    pointLabel: "y",
    pointLabelYOffset: -12,
    enableGridX: false, 
    enableGridY: true, 
    axisTop: false, 
    axisRight: false,
    isInteractive: true,
    useMesh: true,
    animate: true,
    legDirection: "column",
    legendTranslateX: 100,
    legendTranslateY: 0,
    anchor: "bottom-right",
    legendItemSpacing: 2,
    legendSymbolSize: 20,
    itemDirection: "left-to-right",
}

export interface IBULLET_PROPS {
    layout?:String,
    reverse?: Boolean,
    measureSize?: Number,
    markerSize?: Number,
    rangeBorderWidth?: Number,
    rangeBorderColor?: String,
    rangeColors?: String
    measureBorderWidth?: Number,
    measureBorderColor?: String,
    markerColor?: String,
    axesPosition?: String,
    titlePosition?: String,
    titleOffsetX?: Number,
    titleOffsetY?: Number,
    titleRotation?: Number,
    animate?: Boolean,
    isInteractive?: Boolean,
}

export const BULLET_PROPS: IBULLET_PROPS = {
    layout:"horizontal",
    reverse: false,
    measureSize: 0.4,
    markerSize: 0.6,
    rangeBorderWidth: 0,
    rangeBorderColor: "rgb(0, 0, 0)",
    rangeColors: "cool",
    measureBorderWidth: 0,
    measureBorderColor: "rgb(0, 0, 0)",
    markerColor: "inferno",
    axesPosition: "after",
    titlePosition: "before",
    titleOffsetX: -50,
    titleOffsetY: 0,
    titleRotation: 0,
    animate: true,
    isInteractive: true,
}