import React from "react";
import Button from '@mui/material/Button';
import ButtonGroup from '@mui/material/ButtonGroup';
import { Box, Typography, useTheme } from '@mui/material';
import { tokens } from "../theme";

export function SettingBlock({ title, nameParam1, nameParam2, valParam1, valParam2, value, updateData }) {
    const theme = useTheme()
    const colors = tokens(theme.palette.mode)

    const buttons = [
        <Button key="one" sx={{
            backgroundColor: value === valParam1 ? colors.greenAccent[700] : colors.primary[400],
            color: colors.primary[200],
            fontSize: "14px",
            fontWeight: "bold",
            padding: "5px 20px",
            width: "150px"
          }} onClick={() => { updateData(valParam1, false) }}>{nameParam1}</Button>,
        <Button key="two" sx={{
            backgroundColor: value === valParam2 ? colors.greenAccent[700] : colors.primary[400],
            color: colors.primary[200],
            fontSize: "14px",
            fontWeight: "bold",
            padding: "5px 20px",
            width: "150px"
          }} onClick={() => { updateData(valParam2, true) }}>{nameParam2}</Button>,
      ];
    return (
        <div style={{marginLeft: "20px", height: "100px"}}>
            <Typography variant="h4" color={colors.greenAccent[300]} marginBottom={1}>{title}</Typography>
            <Box
                sx={{
                    display: 'flex',
                    flexDirection: 'column',
                    alignItems: 'left',
                    '& > *': {
                    },
                }}
                >
                <ButtonGroup size="small" aria-label="small button group">
                    {buttons}
                </ButtonGroup>
            </Box>
        </div>
    )
}