import Box from '@mui/material/Box';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import { Select, useTheme, Typography } from '@mui/material';
import { tokens } from '../theme';

export default function Selector({ title, names, mainName, updateData }) {
  const theme = useTheme()
  const colors = tokens(theme.palette.mode)

  const handleChange = (event) => {
    updateData(event.target.value);
  };

  return (
    <>
      <Typography variant="h4" color={colors.greenAccent[300]} marginBottom={1} marginTop={2}>{title}</Typography>
      <Box sx={{ width: 300, marginBottom: 2 }}>
        <FormControl fullWidth>
        <InputLabel id="demo-multiple-name-label">{mainName}</InputLabel>
          <Select
            labelId="demo-simple-select-standard-label"
            id="demo-multiple-name"
            value={mainName}
            label={mainName}
            onChange={handleChange}
            >
            {names.map((name) => (
              <MenuItem
                key={name}
                value={name}
              >
                {name}
              </MenuItem> 
            ))}
          </Select>
        </FormControl>
      </Box>
    </>
  );
}