import { ResponsivePie } from "@nivo/pie";
import { tokens } from "../theme";
import { useTheme } from "@mui/material";

const PieChart = ({ data, isDashboard, ...graphProps }) => {
  const theme = useTheme();
  const colors = tokens(theme.palette.mode);
  return (
    <ResponsivePie
      data={data}
      theme={{
        axis: {
          domain: {
            line: {
              stroke: colors.grey[100],
            },
          },
          legend: {
            text: {
              fill: colors.grey[100],
            },
          },
          ticks: {
            line: {
              stroke: colors.grey[100],
              strokeWidth: 1,
            },
            text: {
              fill: colors.grey[100],
            },
          },
        },
        legends: {
          text: {
            fill: colors.grey[100],
          },
        },
      }}
      margin={{ top: 40, right: 80, bottom: 80, left: 80 }}
      innerRadius={graphProps.innerRadius}
      padAngle={graphProps.padAngle}
      cornerRadius={graphProps.cornerRadius}
      activeOuterRadiusOffset={8}
      borderColor={graphProps.borderColor}
      arcLinkLabelsSkipAngle={graphProps.arcLinkLabelsSkipAngle}
      arcLinkLabelsTextColor={graphProps.arcLinkLabelsTextColor}
      arcLinkLabelsThickness={graphProps.arcLinkLabelsThickness}
      arcLinkLabelsColor={graphProps.arcLinkLabelsColor}
      enableArcLabels={graphProps.enableArcLabels}
      arcLabelsRadiusOffset={graphProps.arcLabelsRadiusOffset}
      arcLabelsSkipAngle={graphProps.arcLabelsSkipAngle}
      startAngle={graphProps.startAngle}
      endAngle={graphProps.endAngle}
      colors={{"scheme": `${graphProps.schem}`}}
      borderWidth={graphProps.borderWidth}
      arcLabelsTextColor={graphProps.arcLabelsTextColor}
      enableArcLinkLabels={graphProps.enableArcLinkLabels}
      arcLinkLabelsDiagonalLength={graphProps.arcLinkLabelsDiagonalLength}
      arcLinkLabelsStraightLength={graphProps.arcLinkLabelsStraightLength}
      arcLinkLabelsTextOffset={graphProps.arcLinkLabelsTextOffset}
      isInteractive={graphProps.isInteractive}
      animate={graphProps.animate}
      defs={[
        {
          id: "dots",
          type: "patternDots",
          background: "inherit",
          color: "rgba(255, 255, 255, 0.3)",
          size: 4,
          padding: 1,
          stagger: true,
        },
        {
          id: "lines",
          type: "patternLines",
          background: "inherit",
          color: "rgba(255, 255, 255, 0.3)",
          rotation: -45,
          lineWidth: 6,
          spacing: 10,
        },
      ]}
      legends={isDashboard ? undefined : [
        {
          anchor: `${graphProps.anchor}`,
          direction: `${graphProps.legDirection}`,
          justify: false,
          translateX: Number(graphProps.legendTranslateX),
          translateY: Number(graphProps.legendTranslateY),
          itemsSpacing: Number(graphProps.legendItemSpacing),
          itemWidth: 100,
          itemHeight: 18,
          itemTextColor: "#999",
          itemDirection: `${graphProps.itemDirection}`,
          itemOpacity: 1,
          symbolSize: Number(graphProps.legendSymbolSize),
          symbolShape: "circle",
          effects: [
            {
              on: "hover",
              style: {
                itemTextColor: "#000",
              },
            },
          ],
        },
      ]}
    />
  );
};

export default PieChart;