import React from "react";
import { Box, Typography, useTheme, Slider } from '@mui/material';
import { tokens } from "../theme";

export function NonLinearSlider({ title, text, min, max, step, pad, updateData }) {
  const theme = useTheme()
  const colors = tokens(theme.palette.mode)

  const handleChange = (event, newValue) => {
    if (typeof newValue === 'number') {
      updateData(newValue)
    }
  };
    
  return (
        <div style={{marginLeft: "20px", height: "120px"}}>
            <Typography variant="h4" color={colors.greenAccent[300]} marginBottom={1}>{title}</Typography>
            <Box sx={{ width: 250 }}>
              <Typography id="non-linear-slider" gutterBottom>
                Storage: {pad} {text}
              </Typography>
              <Slider
                value={pad}
                min={min}
                step={step}
                max={max}
                onChange={handleChange}
                valueLabelDisplay="auto"
                aria-labelledby="non-linear-slider"
              />
            </Box>
        </div>
    )
}