import React from "react";

interface ModalProps {
    children: React.ReactNode
    title: string
    width: string
    left: number
    onClose: () => void
}

export function Modal({ children, title, width, left, onClose }: ModalProps) {
    return (
        <>
            <div style={{position: "fixed", background: "black", opacity: 0.5, top: 0, left: 0, right: 0, bottom: 0}} onClick={onClose}></div>
            <div style={{width: width, minHeight: "350px", maxHeight: "100vh", padding: "10px", borderRadius: "10px", background: "white", position: "absolute", top: 50, marginLeft: left, transform: "translateX(0.125rem)", color: "black", zIndex: 10}}>
                <h1 style={{fontSize: "2rem", lineHeight: "3.5rem", textAlign: "center"}}>{ title }</h1>
                { children }
            </div>
        </>
    )
}