import { ResponsiveLine } from "@nivo/line";
import { useTheme } from "@mui/material";
import { tokens } from "../theme";

const LineChart = ({ data, xName, yName, ...graphProps }) => {
  const theme = useTheme();
  const colors = tokens(theme.palette.mode);

  return (
    <ResponsiveLine
      data={data}
      theme={{
        axis: {
          domain: {
            line: {
              stroke: colors.grey[100],
            },
          },
          legend: {
            text: {
              fill: colors.grey[100],
            },
          },
          ticks: {
            line: {
              stroke: colors.grey[100],
              strokeWidth: 1,
            },
            text: {
              fill: colors.grey[100],
            },
          },
        },
        legends: {
          text: {
            fill: colors.grey[100],
          },
        },
        tooltip: {
          container: {
            color: colors.primary[500],
          },
        },
      }}
      colors={{ scheme: `${graphProps.schem}` }} 
      margin={{ top: 50, right: 110, bottom: 50, left: 60 }}
      xScale={{ type: `${graphProps.xScaleType}` }}
      yScale={{
        type: `${graphProps.yScaleType}`,
        min: "auto",
        max: "auto",
        stacked: true,
        reverse: false,
      }}
      yFormat=" >-.2f"
      curve={graphProps.curve}
      lineWidth={graphProps.lineWidth}
      enableArea={graphProps.enableArea}
      areaOpacity={graphProps.areaOpacity}
      enablePoints={graphProps.enablePoints}
      enablePointLabel={graphProps.enablePointLabel}
      pointLabel={graphProps.pointLabel}
      axisTop={graphProps.axisTop}
      axisRight={graphProps.axisRight}
      animate={graphProps.animate}
      axisBottom={{
        orient: "bottom",
        tickSize: 0,
        tickPadding: 5,
        tickRotation: 0,
        legend: graphProps.showXName ? undefined : xName, 
        legendOffset: 36,
        legendPosition: "middle",
      }}
      axisLeft={{
        orient: "left",
        tickValues: 5, 
        tickSize: 3,
        tickPadding: 5,
        tickRotation: 0,
        legend: graphProps.showYName ? undefined : yName, 
        legendOffset: -40,
        legendPosition: "middle",
      }}
      enableGridX={graphProps.enableGridX}
      enableGridY={graphProps.enableGridY}
      pointSize={graphProps.pointSize}
      pointColor={graphProps.pointColor}
      pointBorderWidth={graphProps.pointBorderWidth}
      pointBorderColor={{ from: "serieColor" }}
      pointLabelYOffset={graphProps.pointLabelYOffset}
      isInteractive={graphProps.isInteractive}
      useMesh={graphProps.useMesh}
      legends={graphProps.isDashboard ? undefined : [
        {
          anchor: `${graphProps.anchor}`,
          direction: `${graphProps.legDirection}`,
          justify: false,
          translateX: Number(graphProps.legendTranslateX),
          translateY: Number(graphProps.legendTranslateY),
          itemsSpacing: Number(graphProps.legendItemSpacing),
          itemDirection: `${graphProps.itemDirection}`,
          itemWidth: 80,
          itemHeight: 20,
          itemOpacity: 0.75,
          symbolSize: Number(graphProps.legendSymbolSize),
          symbolShape: "circle",
          symbolBorderColor: "rgba(0, 0, 0, .5)",
          effects: [
            {
              on: "hover",
              style: {
                itemBackground: "rgba(0, 0, 0, .03)",
                itemOpacity: 1,
              },
            },
          ],
        },
      ]}
    />
  );
};

export default LineChart;