import React from 'react'
import { Typography, useTheme, Select, InputLabel, MenuItem } from '@mui/material'
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import { tokens } from '../theme'

const GraphDataSet = ({
  radioGraphValue,
  handleRadioGraphChange,
  radioDataValue,
  handleRadioDataChange,
  colsToShow,
  setColsToShow,
  rowsToShow,
  setRowsToShow,
  errorMessage
}) => {
  const theme = useTheme()
  const colors = tokens(theme.palette.mode)

  return (
    <div style={{
        margin: "30px 70px",
      }}>
        <div style={{
          display: "flex",
          justifyContent: "space-around"
        }}>
          <div>
          <Typography variant="h4" color={colors.grey[100]} margin={1}>Graph Type</Typography>
          <FormControl>
            <RadioGroup
              aria-labelledby="demo-radio-buttons-group-label"
              name="radio-buttons-group"
              value={radioGraphValue}
              onChange={handleRadioGraphChange}
              >
              <FormControlLabel value="bar" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Bar Chart" />
              <FormControlLabel value="bullet" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Bullet Chart" />
              <FormControlLabel value="pie" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Pie Chart" />
              <FormControlLabel value="line" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }} />} label="Line Chart" />
            </RadioGroup>
          </FormControl>
          </div>

          {radioGraphValue === "bar" &&
            <div>
            <Typography variant="h4" color={colors.grey[100]} margin={1}>Data</Typography>
            <FormControl>
              <RadioGroup
                aria-labelledby="demo-radio-buttons-group-label"
                name="radio-btns-group"
                value={radioDataValue}
                onChange={handleRadioDataChange}
                >
                <Typography variant="h5" color={colors.grey[100]}>Real Data</Typography>
                <FormControlLabel value="result" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }} />} label="Result" />
                <FormControlLabel value="product" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }} />} label="Products" />
                <FormControlLabel value="defect" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Defects" />
                <FormControlLabel value="batch_number" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Batch Number" />
                <Typography variant="h5" color={colors.grey[100]}>Picking</Typography>
                <FormControlLabel value="repeatability" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Repeatebility" />
              </RadioGroup>
            </FormControl>
            </div>
          }

          {radioGraphValue === "line" &&
            <div>
            <Typography variant="h4" color={colors.grey[100]} margin={1}>Data</Typography>
            <FormControl>
              <RadioGroup
                aria-labelledby="demo-radio-buttons-group-label"
                name="radio-btns-group"
                value={radioDataValue}
                onChange={handleRadioDataChange}
                >
                <Typography variant="h5" color={colors.grey[100]}>Real Data</Typography>
                <FormControlLabel value="result" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Defects" />
              </RadioGroup>
            </FormControl>
            </div>
          }

          {radioGraphValue === "bullet" &&
            <div>
            <Typography variant="h4" color={colors.grey[100]} margin={1}>Data</Typography>
            <FormControl>
              <RadioGroup
                aria-labelledby="demo-radio-buttons-group-label"
                name="radio-btns-group"
                value={radioDataValue}
                onChange={handleRadioDataChange}
                >
                <Typography variant="h5" color={colors.grey[100]}>Real Data</Typography>
                <FormControlLabel value="result" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Result" />
                <Typography variant="h5" color={colors.grey[100]}>Picking</Typography>
                <FormControlLabel value="repeatebility" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Repeatebility" />
              </RadioGroup>
            </FormControl>
            </div>
          }

          {radioGraphValue === "pie" &&
            <div>
            <Typography variant="h4" color={colors.grey[100]} margin={1}>Data</Typography>
            <FormControl>
              <RadioGroup
                aria-labelledby="demo-radio-buttons-group-label"
                name="radio-btns-group"
                value={radioDataValue}
                onChange={handleRadioDataChange}
                >
                <Typography variant="h5" color={colors.grey[100]}>Real Data</Typography>
                <FormControlLabel value="result" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Defects" />
                <FormControlLabel value="batch_number" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Batch Number" />
                <FormControlLabel value="product" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Product" />
                <Typography variant="h5" color={colors.grey[100]}>Picking</Typography>
                <FormControlLabel value="ground_truth_result" control={<Radio sx={{color: "grey", '&.Mui-checked': { color: "blue" } }}/>} label="Ground Truth" />
              </RadioGroup>
            </FormControl>
            </div>
          }

        </div>
        <div>
          <div style={{display: "inline-block", marginRight: "1em"}}>
            <InputLabel id="colsToShowLabel" sx={{color: "grey"}}> Width in columns </InputLabel>
            <Select
              labelId="colsToShowLabel"
              id="colsToShow"
              value={colsToShow}
              label="Number of columns to show"
              onChange={(e) => {setColsToShow(e.target.value)}}
            >
              {["One", "Two", "Three", "Four", "Five", "Six",].map(
                (digit, number) => <MenuItem key={"colSelect" + digit} value={number + 1}> {digit} </MenuItem>
              )}
            </Select>
          </div>
          <div style={{display: "inline-block"}}>
            <InputLabel id="rowsToShowLabel" sx={{color: "grey"}}> Height in rows </InputLabel>
            <Select
              labelId="rowsToShowLabel"
              id="rowsToShow"
              value={rowsToShow}
              label="Number of rows to show"
              onChange={(e) => {setRowsToShow(e.target.value)}}
            >
              {["One", "Two", "Three",].map(
                (digit, number) => <MenuItem key={"colSelect" + digit} value={number + 1}> {digit} </MenuItem>
              )}
            </Select>
          </div>
        </div>
  
        {/* ERROR MESSAGE */}
        <div style={{color: "red"}}>
          {errorMessage}
        </div>
      </div>
  )
}

export default GraphDataSet