import LineChart from "../components/LineChart";
import BarChart from "../components/BarChart";
import PieChart from "../components/PieChart";
import { useEffect, useState } from "react";
import axios from "axios";
import BulletChart from "./BulletChart";

const LINKS = {
    pie: {
        result: "http://127.0.0.1:5000/real_data/defects/count",
        batch_number: "http://127.0.0.1:5000/real_data/batch_number/count",
        product: "http://127.0.0.1:5000/real_data/product/count",
        ground_truth_result: "http://127.0.0.1:5000/picking/ground_truth_result/count",
    },
    bar: {
        result: "http://127.0.0.1:5000/real_data/prod/result",
        batch_number: "http://127.0.0.1:5000/real_data/prod/batch_number",
        repeatability: "http://127.0.0.1:5000/picking/detail_id/repeatability",
        product: "http://127.0.0.1:5000/real_data/prod/product",
        picking_result: "http://127.0.0.1:5000/picking/result",
        defect: "http://127.0.0.1:5000/bar/defects/"
    },
    bullet: {
        result: "http://127.0.0.1:5000/bullet/result/",
        repeatebility: "http://127.0.0.1:5000/bullet/repeatability/" 
    },
    line: {
        result: "http://127.0.0.1:5000/line/defects/",
    }
}

const Graph = ({colors, type, dataType, rows, graphProps}) => {
    const [data, setData] = useState([])

    let keys = []
    let nameX = "product"
    let nameY = "value"
    let ind = "product"

    if (type === "bar") {
      if (dataType === "result") {
        keys = ["~NOK", "~OK"]
      } else if (dataType === "product") {
        keys = ["product1", "product2"]
      } else if (dataType === "batch_number") {
        keys = ["231107Z12568JK1102", "15897JK2568KK7128", "231107J12568JK3659"]
      } else if (dataType === "repeatability") {
        keys = ["~NOK", "~OK"]
        nameX = "detail_id"
        ind = "detail_id"
      } else if (dataType === "ground_truth") {
        keys = ["0", "25", "50", "75", "100"]
        nameX = "label"
        ind = "value"
      } else if (dataType === "picking_result") {
        keys = ["NOK", "OK"]
        nameX = "label"
        ind = "label"
      } else {
        keys = ["product1", "product2"]
        nameX = "defect"
        ind = "defect"
      }
    }
     else if (type === "line") {
      nameX = "defects"
    }

    useEffect(() => {
        axios.get(LINKS[type][dataType])
        .then((res) => {
            setData(res.data)
        })
    }, [])

    return (
      <div style={{height: `${210 * rows}px`}}>
        {type === "line" && <LineChart
                              data={data}
                              xName={nameX}
                              yName={nameY}
                              {...graphProps}
                              />}
        {(type === "bar") &&  <BarChart
                                data={data}
                                keys={keys}
                                xName = {nameX}
                                yName = {nameY}
                                indexBy={ind}
                                {...graphProps}
                              />}
        {(type === "pie") && <PieChart
                                data={data}
                                {...graphProps}
                              />}
        {(type === "bullet") && <BulletChart
                                data={data}
                                {...graphProps}
                              />}
      </div>
    )
  };

export default Graph