
import { useEffect, useState } from "react"
import Line from "../scenes/dashboard/charts/Line"
import Pie from "../scenes/dashboard/charts/Pie"
import Bullet from "../scenes/dashboard/charts/Bullet"
import Bar from "../scenes/dashboard/charts/Bar"

const EditGraph = ({type, graph, onChangeGraphProps, graphProps}) => {
    const [componentToShow, setComponentToShow] = useState(<></>)

    useEffect(() => {
        switch (type) {
            case "bar":
                setComponentToShow(
                    <Bar
                        graph={graph}
                        onChangeGraphProps={onChangeGraphProps}
                        graphProps={graphProps}
                    />
                )
                break
            case "line":
                setComponentToShow(
                    <Line
                        graph={graph}
                        onChangeGraphProps={onChangeGraphProps}
                        graphProps={graphProps}
                    />
                )
                break
            case "pie":
                setComponentToShow(
                    <Pie
                        graph={graph}
                        onChangeGraphProps={onChangeGraphProps}
                        graphProps={graphProps}
                    />
                )
                break
            case "bullet":
                setComponentToShow(
                    <Bullet
                        graph={graph}
                        onChangeGraphProps={onChangeGraphProps}
                        graphProps={graphProps}
                    />
                )
                break
        }
    }, [])

    return componentToShow
}

export default EditGraph