import React from 'react'
import { MuiColorInput } from 'mui-color-input'
import { Typography, useTheme } from '@mui/material'
import { tokens } from '../theme'

const ColorInput = ({title, col, updateData}) => {
  const theme = useTheme()
  const colors = tokens(theme.palette.mode)

  const handleChange = (color) => {
    updateData(color)
  }

  return (
    <>
        <Typography variant="h4" color={colors.greenAccent[300]} marginBottom={1}>{title}</Typography>
        <MuiColorInput value={col} onChange={handleChange} size="small" variant="outlined"/>
    </>
  )
}

export default ColorInput