import { ResponsiveBullet } from '@nivo/bullet'

const BulletChart = ({ data, ...graphProps }) => (
    <ResponsiveBullet
        data={data}
        margin={{ top: 50, right: 90, bottom: 50, left: 90 }}
        spacing={46}
        titleAlign="start"
        measureSize={graphProps.measureSize}
        minValue={'auto'}
        maxValue={'auto'}
        layout={graphProps.layout}
        reverse={graphProps.reverse}
        markerSize={graphProps.markerSize}
        rangeBorderWidth={graphProps.rangeBorderWidth}
        rangeBorderColor={graphProps.rangeBorderColor}
        rangeColors={`seq:${graphProps.rangeColors}`}
        measureBorderWidth={graphProps.measureBorderWidth}
        measureBorderColor={graphProps.measureBorderColor}
        markerColors={`seq:${graphProps.markerColors}`}
        axisPosition={graphProps.axesPosition}
        titlePosition={graphProps.titlePosition}
        titleOffsetX={graphProps.titleOffsetX}
        titleOffsetY={graphProps.titleOffsetY}
        titleRotation={graphProps.titleRotation}
        animate={graphProps.animate}
        isInteractive={graphProps.isInteractive}
    />
)

export default BulletChart;
