import { useTheme } from "@mui/material";
import { ResponsiveBar } from "@nivo/bar";
import { tokens } from "../theme";

const BarChart = ({data, keys, xName, yName, indexBy, ...graphProps}) => {
    const theme = useTheme();
    const colors = tokens(theme.palette.mode);

    return (
      <ResponsiveBar
        data={data}
        theme={{
          axis: {
            domain: {
              line: {
                stroke: colors.grey[100],
              },
            },
            legend: {
              text: {
                fill: colors.grey[100],
              },
            },
            ticks: {
              line: {
                stroke: colors.grey[100],
                strokeWidth: 1,
              },
              text: {
                fill: colors.grey[100],
              },
            },
          },
          legends: {
            text: {
              fill: colors.grey[100],
            },
          },
        }}
        keys={keys}
        indexBy={indexBy}
        margin={{ top: 50, right: 130, bottom: 50, left: 60 }}
        padding={graphProps.pad}
        valueScale={{ type: "linear" }}
        indexScale={{ type: "band", round: true }}
        colors= {{ scheme: `${graphProps.schem}` }}
        groupMode={graphProps.group}
        layout={graphProps.layout}
        reverse={graphProps.reverse}
        innerPadding={graphProps.innerPad}
        borderRadius={graphProps.borderRad}
        borderWidth={graphProps.borderWidth}
        enableGridX={graphProps.enableGridX}
        enableGridY={graphProps.enableGridY}
        isInteractive={graphProps.isInteractive}
        isFocusable={graphProps.isFocusable}
        animate={graphProps.animate}
        defs={[
          {
            id: "dots",
            type: "patternDots",
            background: "inherit",
            color: "#38bcb2",
            size: 4,
            padding: 1,
            stagger: true,
          },
          {
            id: "lines",
            type: "patternLines",
            background: "inherit",
            color: "#eed312",
            rotation: -45,
            lineWidth: 6,
            spacing: 10,
          },
        ]}
        borderColor={graphProps.borderCol}
        axisTop={graphProps.axisTop}
        axisRight={graphProps.axisRight}
        axisBottom={{
          tickSize: 5,
          tickPadding: 5,
          tickRotation: 0,
          legend: graphProps.showXName ? undefined : xName, 
          legendPosition: "middle",
          legendOffset: 32,
        }}
        axisLeft={{
          tickSize: 5,
          tickPadding: 5,
          tickRotation: 0,
          legend: graphProps.showYName ? undefined : yName, 
          legendPosition: "middle",
          legendOffset: -40,
        }}
        enableLabel={graphProps.enableLabel}
        labelSkipWidth={12}
        labelSkipHeight={12}
        labelTextColor={graphProps.labelCol}
        legends={graphProps.isDashboard ? undefined : [
          {
            dataFrom: "keys",
            anchor: `${graphProps.anchor}`,
            direction: `${graphProps.legDirection}`,
            justify: false,
            translateX: Number(graphProps.legendTranslateX),
            translateY: Number(graphProps.legendTranslateY),
            itemsSpacing: Number(graphProps.legendItemSpacing),
            itemWidth: 100,
            itemHeight: 20,
            itemDirection: `${graphProps.itemDirection}`,
            itemOpacity: 0.85,
            symbolSize: Number(graphProps.legendSymbolSize),
            effects: [
              {
                on: "hover",
                style: {
                  itemOpacity: 1,
                },
              },
            ],
          },
        ]}
        role="application"
      />
    );
  };
  
  export default BarChart;